/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;

public class RecipeGrapplingHookUpgrades
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting craftMatrix, World world) {
        int size = craftMatrix.func_70302_i_();
        if (size < 3) {
            return false;
        }
        ItemStack hook = ItemStack.field_190927_a;
        int tongues = 0;
        int teeth = 0;
        for (int i = 0; i < size; ++i) {
            ItemStack stack = craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ItemRegistry.GRAPPLING_HOOK) {
                hook = stack;
                continue;
            }
            if (stack.func_77973_b() == ItemRegistry.SHAMBLER_TONGUE) {
                ++tongues;
                continue;
            }
            if (!ItemMisc.EnumItemMisc.ANGLER_TOOTH.isItemOf(stack)) continue;
            ++teeth;
        }
        return !hook.func_190926_b() && hook.func_77952_i() < hook.func_77958_k() && tongues > 0 && teeth >= 2;
    }

    public ItemStack func_77572_b(InventoryCrafting craftMatrix) {
        ItemStack hook = ItemStack.field_190927_a;
        int tongues = 0;
        int teeth = 0;
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ItemRegistry.GRAPPLING_HOOK) {
                hook = stack;
                continue;
            }
            if (stack.func_77973_b() == ItemRegistry.SHAMBLER_TONGUE) {
                ++tongues;
                continue;
            }
            if (!ItemMisc.EnumItemMisc.ANGLER_TOOTH.isItemOf(stack)) continue;
            ++teeth;
        }
        int nodesPerUpgrade = 3;
        int newDamage = Math.min(hook.func_77952_i() + Math.min(tongues, teeth / 2) * nodesPerUpgrade, hook.func_77958_k());
        hook = hook.func_77946_l();
        hook.func_77964_b(newDamage);
        return hook;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 3;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77571_b() {
        return new ItemStack(ItemRegistry.GRAPPLING_HOOK);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        int upgrades;
        ItemStack hook = ItemStack.field_190927_a;
        int tongues = 0;
        int teeth = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ItemRegistry.GRAPPLING_HOOK) {
                hook = stack;
                continue;
            }
            if (stack.func_77973_b() == ItemRegistry.SHAMBLER_TONGUE) {
                ++tongues;
                continue;
            }
            if (!ItemMisc.EnumItemMisc.ANGLER_TOOTH.isItemOf(stack)) continue;
            ++teeth;
        }
        int nodesPerUpgrade = 3;
        int newDamage = Math.min(hook.func_77952_i() + Math.min(tongues, teeth / 2) * nodesPerUpgrade, hook.func_77958_k());
        int tonguesToRemove = upgrades = MathHelper.func_76123_f((float)((float)(newDamage - hook.func_77952_i()) / (float)nodesPerUpgrade));
        int teethToRemove = upgrades * 2;
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            boolean consume = true;
            if (stack.func_77973_b() == ItemRegistry.SHAMBLER_TONGUE) {
                if (tonguesToRemove > 0) {
                    --tonguesToRemove;
                } else {
                    consume = false;
                }
            } else if (ItemMisc.EnumItemMisc.ANGLER_TOOTH.isItemOf(stack)) {
                if (teethToRemove > 0) {
                    --teethToRemove;
                } else {
                    consume = false;
                }
            }
            if (consume) {
                remaining.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
                continue;
            }
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            remaining.set(i, (Object)stack);
        }
        return remaining;
    }
}

