/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.block.structure.BlockBeamLensSupport;
import thebetweenlands.common.block.structure.BlockBeamRelay;
import thebetweenlands.common.block.structure.BlockBeamTube;
import thebetweenlands.common.block.structure.BlockDiagonalEnergyBarrier;
import thebetweenlands.common.block.structure.BlockDungeonDoorRunes;
import thebetweenlands.common.block.structure.BlockEnergyBarrierMud;
import thebetweenlands.common.tile.TileEntityDungeonDoorRunes;

public class TileEntityBeamRelay
extends TileEntity
implements ITickable {
    public boolean active;
    public boolean in_down;
    public boolean in_up;
    public boolean in_north;
    public boolean in_south;
    public boolean in_west;
    public boolean in_east;
    private int particleTimer = 0;

    public void func_73660_a() {
        if (this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() != null) {
            if (((Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockBeamRelay.POWERED)).booleanValue() && !this.active) {
                this.setActive(true);
            }
            if (!((Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockBeamRelay.POWERED)).booleanValue() && this.active) {
                this.setActive(false);
            }
        }
        if (this.active) {
            this.activateBlock();
        } else {
            this.deactivateBlock();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBeamParticles(Vec3d target) {
        Vec3d dir = target.func_72432_b();
        float beamScale = 2.5f;
        float beamScaleInset = 0.75f;
        Vec3d beamStart = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5 - dir.field_72450_a * (double)beamScale * (double)beamScaleInset * (double)0.1f, (double)this.field_174879_c.func_177956_o() + 0.5 - dir.field_72448_b * (double)beamScale * (double)beamScaleInset * (double)0.1f, (double)this.field_174879_c.func_177952_p() + 0.5 - dir.field_72449_c * (double)beamScale * (double)beamScaleInset * (double)0.1f);
        Vec3d beamEnd = new Vec3d(target.field_72450_a + dir.field_72450_a * (double)beamScale * (double)beamScaleInset * (double)0.1f * 2.0, target.field_72448_b + dir.field_72448_b * (double)beamScale * (double)beamScaleInset * (double)0.1f * 2.0, target.field_72449_c + dir.field_72449_c * (double)beamScale * (double)beamScaleInset * (double)0.1f * 2.0);
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.BEAM, BLParticles.PUZZLE_BEAM_2.create(this.field_145850_b, beamStart.field_72450_a, beamStart.field_72448_b, beamStart.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0, 0.0, 0.0)).withColor(40.0f, 220.0f, 130.0f, 1.0f)).withScale(beamScale)).withData(30, beamEnd)));
        for (int i = 0; i < 3; ++i) {
            float offsetLen = this.field_145850_b.field_73012_v.nextFloat();
            Vec3d offset = new Vec3d(target.field_72450_a * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f, target.field_72448_b * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f, target.field_72449_c * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f);
            float vx = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f;
            float vy = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f + 0.008f;
            float vz = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f;
            float scale = 0.5f + this.field_145850_b.field_73012_v.nextFloat();
            if (ShaderHelper.INSTANCE.canUseShaders() && this.field_145850_b.field_73012_v.nextBoolean()) {
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.HEAT_HAZE_BLOCK_ATLAS, BLParticles.SMOOTH_SMOKE.create(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + offset.field_72450_a, (double)this.field_174879_c.func_177956_o() + 0.5 + offset.field_72448_b, (double)this.field_174879_c.func_177952_p() + 0.5 + offset.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vx, vy, vz)).withColor(1.0f, 1.0f, 1.0f, 0.2f)).withScale(scale * 8.0f)).withData(80, true, Float.valueOf(0.0f), true)));
                continue;
            }
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + offset.field_72450_a, (double)this.field_174879_c.func_177956_o() + 0.5 + offset.field_72448_b, (double)this.field_174879_c.func_177952_p() + 0.5 + offset.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vx, vy, vz)).withColor(40.0f, 220.0f, 130.0f, 1.0f)).withScale(scale)).withData(100)));
        }
    }

    public void activateBlock() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockBeamRelay.field_176387_N);
        BlockPos targetPos = this.func_174877_v().func_177967_a(facing, this.getDistanceToObstruction(facing));
        if (this.field_145850_b.field_72995_K) {
            if (this.particleTimer++ >= 20) {
                this.particleTimer = 0;
                this.spawnBeamParticles(new Vec3d((double)(targetPos.func_177958_n() - this.field_174879_c.func_177958_n()), (double)(targetPos.func_177956_o() - this.field_174879_c.func_177956_o()), (double)(targetPos.func_177952_p() - this.field_174879_c.func_177952_p())));
            }
        } else {
            TileEntity targetTile;
            IBlockState stateofTarget = this.func_145831_w().func_180495_p(targetPos);
            if (stateofTarget.func_177230_c() instanceof BlockBeamRelay && this.func_145831_w().func_175625_s(targetPos) instanceof TileEntityBeamRelay) {
                targetTile = (TileEntityBeamRelay)this.func_145831_w().func_175625_s(targetPos);
                targetTile.setTargetIncomingBeam(facing.func_176734_d(), true);
                if (!((Boolean)this.func_145831_w().func_180495_p(targetPos).func_177229_b((IProperty)BlockBeamRelay.POWERED)).booleanValue()) {
                    stateofTarget = stateofTarget.func_177231_a((IProperty)BlockBeamRelay.POWERED);
                    this.func_145831_w().func_180501_a(targetPos, stateofTarget, 3);
                }
            }
            if (stateofTarget.func_177230_c() instanceof BlockDungeonDoorRunes && this.func_145831_w().func_175625_s(targetPos) instanceof TileEntityDungeonDoorRunes) {
                targetTile = (TileEntityDungeonDoorRunes)this.func_145831_w().func_175625_s(targetPos);
                if (((TileEntityDungeonDoorRunes)targetTile).is_gate_entrance) {
                    ((TileEntityDungeonDoorRunes)targetTile).top_state_prev = ((TileEntityDungeonDoorRunes)targetTile).top_code;
                    ((TileEntityDungeonDoorRunes)targetTile).mid_state_prev = ((TileEntityDungeonDoorRunes)targetTile).mid_code;
                    ((TileEntityDungeonDoorRunes)targetTile).bottom_state_prev = ((TileEntityDungeonDoorRunes)targetTile).bottom_code;
                    this.func_145831_w().func_180501_a(targetPos, stateofTarget, 3);
                }
            }
        }
    }

    public void deactivateBlock() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockBeamRelay.field_176387_N);
        BlockPos targetPos = this.func_174877_v().func_177967_a(facing, this.getDistanceToObstruction(facing));
        IBlockState stateofTarget = this.func_145831_w().func_180495_p(targetPos);
        if (stateofTarget.func_177230_c() instanceof BlockBeamRelay && this.func_145831_w().func_175625_s(targetPos) instanceof TileEntityBeamRelay) {
            TileEntityBeamRelay targetTile = (TileEntityBeamRelay)this.func_145831_w().func_175625_s(targetPos);
            targetTile.setTargetIncomingBeam(facing.func_176734_d(), false);
            if (!targetTile.isGettingBeamed() && ((Boolean)this.func_145831_w().func_180495_p(targetPos).func_177229_b((IProperty)BlockBeamRelay.POWERED)).booleanValue()) {
                stateofTarget = stateofTarget.func_177231_a((IProperty)BlockBeamRelay.POWERED);
                this.func_145831_w().func_180501_a(targetPos, stateofTarget, 3);
            }
        }
    }

    public void setTargetIncomingBeam(EnumFacing facing, boolean state) {
        switch (facing) {
            case DOWN: {
                this.in_down = state;
                break;
            }
            case EAST: {
                this.in_east = state;
                break;
            }
            case NORTH: {
                this.in_north = state;
                break;
            }
            case SOUTH: {
                this.in_south = state;
                break;
            }
            case UP: {
                this.in_up = state;
                break;
            }
            case WEST: {
                this.in_west = state;
                break;
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public int getDistanceToObstruction(EnumFacing facing) {
        IBlockState state;
        int distance = 0;
        for (distance = 1; distance < 14 && ((state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(facing, distance))) == Blocks.field_150350_a.func_176223_P() || state.func_177230_c() instanceof BlockDiagonalEnergyBarrier || state.func_177230_c() instanceof BlockEnergyBarrierMud || state.func_177230_c() instanceof BlockBeamLensSupport || this.isValidBeamTubeLens(state, facing)); ++distance) {
        }
        return distance;
    }

    private boolean isValidBeamTubeLens(IBlockState state, EnumFacing facing) {
        if (!(state.func_177230_c() instanceof BlockBeamTube)) {
            return false;
        }
        if (state.func_177229_b((IProperty)BlockBeamTube.field_176387_N) == facing) {
            return true;
        }
        return state.func_177229_b((IProperty)BlockBeamTube.field_176387_N) == facing.func_176734_d();
    }

    public boolean isGettingBeamed() {
        return this.in_up ? true : (this.in_down ? true : (this.in_north ? true : (this.in_south ? true : (this.in_west ? true : this.in_east))));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("active", this.active);
        nbt.func_74757_a("in_down", this.in_down);
        nbt.func_74757_a("in_up", this.in_up);
        nbt.func_74757_a("in_north", this.in_north);
        nbt.func_74757_a("in_south", this.in_south);
        nbt.func_74757_a("in_west)", this.in_west);
        nbt.func_74757_a("in_east", this.in_east);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.active = nbt.func_74767_n("active");
        this.in_down = nbt.func_74767_n("in_down");
        this.in_up = nbt.func_74767_n("in_up");
        this.in_north = nbt.func_74767_n("in_north");
        this.in_south = nbt.func_74767_n("in_south");
        this.in_west = nbt.func_74767_n("in_west)");
        this.in_east = nbt.func_74767_n("in_east");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

