/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityDecayPitGroundChain
extends TileEntity
implements ITickable {
    public int animationTicksChain = 0;
    public int animationTicksChainPrev = 0;
    public int LENGTH = 5;
    public boolean IS_MOVING = false;
    public boolean IS_SLOW = false;
    public boolean IS_RAISING = false;
    public boolean IS_BROKEN = false;
    public int breakTimer = 0;

    public void func_73660_a() {
        this.animationTicksChainPrev = this.animationTicksChain++;
        if (this.isMoving() && !this.isSlow()) {
            this.animationTicksChain = this.isBroken() ? (this.animationTicksChain += 32) : (this.animationTicksChain += 8);
        }
        if (this.getEntityCollidedWithChains(this.getHangingLengthCollision(0.625, 5.0, 0.625)) != null) {
            this.checkCollisions(this.getEntityCollidedWithChains(this.getHangingLengthCollision(0.625, 5.0, 0.625)));
        }
        if (this.animationTicksChainPrev >= 128) {
            this.animationTicksChainPrev = 0;
            this.animationTicksChain = 0;
            if (!this.isBroken()) {
                this.setMoving(false);
            }
        }
        if (!this.func_145831_w().field_72995_K && this.isBroken()) {
            ++this.breakTimer;
            if (this.breakTimer > 32) {
                if (this.breakTimer % 4 == 0) {
                    this.setLength(this.getLength() - 1);
                    this.updateBlock();
                }
                if (this.getLength() <= 0) {
                    this.func_145831_w().func_175698_g(this.func_174877_v());
                }
            }
        }
    }

    public List<Entity> getEntityCollidedWithChains(AxisAlignedBB chainBox) {
        return this.func_145831_w().func_72872_a(Entity.class, chainBox);
    }

    private void checkCollisions(List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof EntityArrow)) continue;
            EntityArrow arrow = (EntityArrow)entity;
            arrow.func_70634_a(arrow.field_70169_q, arrow.field_70167_r, arrow.field_70166_s);
            arrow.field_70159_w *= (double)-0.1f;
            arrow.field_70181_x *= (double)-0.1f;
            arrow.field_70179_y *= (double)-0.1f;
            arrow.field_70177_z += 180.0f;
            arrow.field_70126_B += 180.0f;
            this.func_145831_w().func_184148_a((EntityPlayer)null, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.5f, 3.0f);
        }
    }

    public AxisAlignedBB getHangingLengthCollision(double x, double y, double z) {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5 - x * 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5 + -z * 0.5, (double)this.func_174877_v().func_177958_n() + 0.5 + x * 0.5, (double)this.func_174877_v().func_177956_o() + y, (double)this.func_174877_v().func_177952_p() + 0.5 + z * 0.5);
    }

    public void setMoving(boolean moving) {
        this.IS_MOVING = moving;
    }

    public boolean isMoving() {
        return this.IS_MOVING;
    }

    public void setSlow(boolean slow) {
        this.IS_SLOW = slow;
    }

    public boolean isSlow() {
        return this.IS_SLOW;
    }

    public void setRaising(boolean raising) {
        this.IS_RAISING = raising;
    }

    public boolean isRaising() {
        return this.IS_RAISING;
    }

    public void setLength(int length) {
        this.LENGTH = length;
    }

    public int getLength() {
        return this.LENGTH;
    }

    public void setBroken(boolean broken) {
        this.IS_BROKEN = broken;
    }

    public boolean isBroken() {
        return this.IS_BROKEN;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("animationTicksChain", this.animationTicksChain);
        nbt.func_74768_a("animationTicksChainPrev", this.animationTicksChainPrev);
        nbt.func_74768_a("length", this.LENGTH);
        nbt.func_74757_a("raising", this.IS_RAISING);
        nbt.func_74757_a("moving", this.IS_MOVING);
        nbt.func_74757_a("broken", this.IS_BROKEN);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.animationTicksChain = nbt.func_74762_e("animationTicksChain");
        this.animationTicksChainPrev = nbt.func_74762_e("animationTicksChainPrev");
        this.LENGTH = nbt.func_74762_e("length");
        this.IS_RAISING = nbt.func_74767_n("raising");
        this.IS_MOVING = nbt.func_74767_n("moving");
        this.IS_BROKEN = nbt.func_74767_n("broken");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void updateBlock() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }
}

