/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import thebetweenlands.common.block.misc.BlockRubberTap;
import thebetweenlands.common.registries.FluidRegistry;

public class TileEntityRubberTap
extends TileEntity
implements IFluidHandler,
ITickable {
    private final FluidTank tank;
    private final IFluidTankProperties[] properties = new IFluidTankProperties[1];
    private int fillProgress = 0;

    public TileEntityRubberTap() {
        this.tank = new FluidTank(FluidRegistry.RUBBER, 0, 1000);
        this.tank.setTileEntity((TileEntity)this);
        this.properties[0] = new FluidTankPropertiesWrapper(this.tank);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.func_145838_q() instanceof BlockRubberTap) {
            FluidStack drained = this.tank.drain(1000, false);
            int ticksPerStep = ((BlockRubberTap)this.func_145838_q()).ticksPerStep;
            if (drained == null || drained.amount < 1000) {
                ++this.fillProgress;
                if (this.fillProgress >= ticksPerStep) {
                    this.tank.fill(new FluidStack(FluidRegistry.RUBBER, 67), true);
                    this.fillProgress = 0;
                    IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
                    this.func_70296_d();
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        tagCompound.func_74768_a("FillProgress", this.fillProgress);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.fillProgress = tagCompound.func_74762_e("FillProgress");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tank.writeToNBT(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.tank.readFromNBT(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (doFill) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (doDrain) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
        }
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (doDrain) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.tank.writeToNBT(nbt);
        nbt.func_74768_a("FillProgress", this.fillProgress);
        return nbt;
    }
}

