/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning;

import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import thebetweenlands.api.entity.spawning.IBiomeSpawnEntriesData;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntriesProvider;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.world.biome.spawning.AreaMobSpawner;

public class BoxMobSpawner
extends AreaMobSpawner {
    private final IBiomeSpawnEntriesData spawnEntriesData = new SimpleSpawnEntriesData();
    private List<AxisAlignedBB> areas = new ArrayList<AxisAlignedBB>();
    private List<ICustomSpawnEntry> spawnEntries = new ArrayList<ICustomSpawnEntry>();
    private int maxEntities;

    public void addArea(AxisAlignedBB area) {
        this.areas.add(area);
    }

    public void clearAreas() {
        this.areas.clear();
    }

    public void setMaxAreaEntities(int maxEntities) {
        this.maxEntities = maxEntities;
    }

    public void addSpawnEntry(ICustomSpawnEntry entry) {
        this.spawnEntries.add(entry);
    }

    public void clearSpawnEntries() {
        this.spawnEntries.clear();
    }

    @Override
    public int getHardEntityLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public List<ICustomSpawnEntry> getSpawnEntries(World world, BlockPos pos, ICustomSpawnEntriesProvider provider) {
        return this.spawnEntries;
    }

    @Override
    public float getMaxEntitiesPerSpawnChunkFraction(int spawnerChunks) {
        if (spawnerChunks > 0) {
            return (float)this.maxEntities / (float)spawnerChunks;
        }
        return 0.0f;
    }

    @Override
    public IBiomeSpawnEntriesData getSpawnEntriesData(World world, BlockPos pos, ICustomSpawnEntriesProvider provider) {
        return this.spawnEntriesData;
    }

    @Override
    protected void updateSpawnerChunks(WorldServer world, Set<ChunkPos> spawnerChunks) {
        spawnerChunks.clear();
        for (AxisAlignedBB area : this.areas) {
            int sx = MathHelper.func_76128_c((double)area.field_72340_a) >> 4;
            int sz = MathHelper.func_76128_c((double)area.field_72339_c) >> 4;
            int ex = MathHelper.func_76128_c((double)area.field_72336_d) >> 4;
            int ez = MathHelper.func_76128_c((double)area.field_72334_f) >> 4;
            for (int cx = sx; cx <= ex; ++cx) {
                for (int cz = sz; cz <= ez; ++cz) {
                    spawnerChunks.add(new ChunkPos(cx, cz));
                }
            }
        }
    }

    @Override
    public boolean isInsideSpawningArea(World world, BlockPos pos, boolean entityCount) {
        return this.isInsideAnyArea(pos) && (entityCount || world.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false) == null);
    }

    private boolean isInsideAnyArea(BlockPos pos) {
        for (AxisAlignedBB area : this.areas) {
            if (!area.func_186668_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1))) continue;
            return true;
        }
        return false;
    }

    private static class SimpleSpawnEntriesData
    implements IBiomeSpawnEntriesData {
        private final TObjectLongMap<ResourceLocation> lastSpawnMap = new TObjectLongHashMap();

        private SimpleSpawnEntriesData() {
        }

        @Override
        public long getLastSpawn(ICustomSpawnEntry spawnEntry) {
            return this.lastSpawnMap.containsKey((Object)spawnEntry.getID()) ? this.lastSpawnMap.get((Object)spawnEntry.getID()) : -1L;
        }

        @Override
        public void setLastSpawn(ICustomSpawnEntry spawnEntry, long lastSpawn) {
            this.lastSpawnMap.put((Object)spawnEntry.getID(), lastSpawn);
        }

        @Override
        public long removeLastSpawn(ICustomSpawnEntry spawnEntry) {
            return this.lastSpawnMap.remove((Object)spawnEntry.getID());
        }
    }
}

