/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.event.AddRainParticlesEvent;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.sky.BLRainRenderer;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class EventHeavyRain
extends TimedEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "heavy_rain");
    private int rainSoundCounter = 0;

    public EventHeavyRain(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(50000) + 60000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(5000) + 8000;
    }

    @Override
    public void setActive(boolean active) {
        if (active && !this.getRegistry().winter.isActive() || !active) {
            super.setActive(active);
        }
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!world.field_72995_K && this.getRegistry().winter.isActive()) {
            this.setActive(false);
        }
        if (this.isActive() && world.field_73011_w instanceof WorldProviderBetweenlands && world.field_73012_v.nextInt(20) == 0 && !world.field_72995_K && world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
            Iterator iterator = worldServer.getPersistentChunkIterable(worldServer.func_184164_w().func_187300_b());
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                if (world.field_73012_v.nextInt(4) != 0) continue;
                int cbx = world.field_73012_v.nextInt(16);
                int cbz = world.field_73012_v.nextInt(16);
                BlockPos pos = chunk.func_177440_h(new BlockPos(chunk.func_76632_l().func_180334_c() + cbx, -999, chunk.func_76632_l().func_180333_d() + cbz));
                if (world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() == BlockRegistry.PUDDLE || !BlockRegistry.PUDDLE.func_176196_c(world, pos)) continue;
                world.func_175656_a(pos, BlockRegistry.PUDDLE.func_176223_P());
            }
        }
        if (world.field_72995_K) {
            this.updateWeather(world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateWeather(World world) {
        Entity entity;
        BLRainRenderer.INSTANCE.update(world);
        Minecraft mc = Minecraft.func_71410_x();
        float particleStrength = world.func_72867_j(1.0f);
        if (!mc.field_71474_y.field_74347_j) {
            particleStrength /= 2.0f;
        }
        if (particleStrength > 0.001f && (entity = mc.func_175606_aa()) != null) {
            BlockPos center = new BlockPos(entity);
            int numParticles = (int)(50.0f * particleStrength * particleStrength);
            if (mc.field_71474_y.field_74362_aa == 1) {
                numParticles >>= 1;
            } else if (mc.field_71474_y.field_74362_aa == 2) {
                numParticles = 0;
            }
            double soundX = 0.0;
            double soundY = 0.0;
            double soundZ = 0.0;
            int spawnedParticles = 0;
            for (int l = 0; l < numParticles; ++l) {
                BlockPos pos = world.func_175725_q(center.func_177982_a(world.field_73012_v.nextInt(10) - world.field_73012_v.nextInt(10), 0, world.field_73012_v.nextInt(10) - world.field_73012_v.nextInt(10)));
                BlockPos below = pos.func_177977_b();
                IBlockState stateBelow = world.func_180495_p(below);
                Biome biome = world.func_180494_b(pos);
                if (pos.func_177956_o() > center.func_177956_o() + 10 || pos.func_177956_o() < center.func_177956_o() - 10 || !biome.func_76738_d() || !(biome.func_180626_a(pos) >= 0.15f)) continue;
                AxisAlignedBB blockAABB = stateBelow.func_185900_c((IBlockAccess)world, below);
                float rangeX = (float)(blockAABB.field_72336_d - blockAABB.field_72340_a);
                float rangeZ = (float)(blockAABB.field_72334_f - blockAABB.field_72339_c);
                float size = 0.025f + world.field_73012_v.nextFloat() * 0.4f;
                if (!(size * 2.0f < rangeX) || !(size * 2.0f < rangeZ)) continue;
                double rx = world.field_73012_v.nextDouble() * (double)(rangeX - size * 2.0f) + (double)size + blockAABB.field_72340_a;
                double rz = world.field_73012_v.nextDouble() * (double)(rangeZ - size * 2.0f) + (double)size + blockAABB.field_72339_c;
                if (stateBelow.func_185904_a() == Material.field_151587_i || stateBelow.func_177230_c() == Blocks.field_189877_df || stateBelow.func_185904_a() == Material.field_151579_a) continue;
                int waterColor = BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos);
                float r = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(waterColor & 0xFF) / 255.0f;
                for (int i = 0; i < 4 + world.field_73012_v.nextInt(6); ++i) {
                    BLParticles.RAIN.spawn(world, (double)below.func_177958_n() + rx, (double)((float)below.func_177956_o() + 0.1f) + blockAABB.field_72337_e, (double)below.func_177952_p() + rz, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withColor(r, g, b + 0.075f, 1.0f));
                }
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_NEAREST_NEIGHBOR, BLParticles.WATER_RIPPLE.create(world, (double)below.func_177958_n() + rx, (double)((float)below.func_177956_o() + 0.1f) + blockAABB.field_72337_e, (double)below.func_177952_p() + rz, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withScale(size * 10.0f)).withColor(r * 1.15f, g * 1.15f, b * 1.15f, 1.0f)));
                if (world.field_73012_v.nextInt(++spawnedParticles) != 0) continue;
                soundX = (double)pos.func_177958_n() + rx;
                soundY = (double)((float)pos.func_177956_o() + 0.1f) + blockAABB.field_72337_e - 1.0;
                soundZ = (double)pos.func_177952_p() + rz;
            }
            if (spawnedParticles > 0 && world.field_73012_v.nextInt(3) < this.rainSoundCounter++) {
                this.rainSoundCounter = 0;
                if (soundY > (double)(center.func_177956_o() + 1) && world.func_175725_q(center).func_177956_o() > MathHelper.func_76141_d((float)center.func_177956_o())) {
                    world.func_184134_a(soundX, soundY, soundZ, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                } else {
                    world.func_184134_a(soundX, soundY, soundZ, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRainParticles(AddRainParticlesEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (world != null && view != null && BetweenlandsWorldStorage.forWorld((World)world).getEnvironmentEventRegistry().heavyRain.isActiveAt(view.field_70165_t, view.field_70163_u, view.field_70161_v)) {
            event.setCanceled(true);
        }
    }
}

