/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class AlgaeFeature
extends BiomeFeature {
    private NoiseGeneratorPerlin algaeNoiseGen;
    private double[] algaeNoise = new double[256];

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        Random rng = new Random(seed);
        this.algaeNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.algaeNoise = this.algaeNoiseGen.func_151599_a(this.algaeNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        float biomeWeight;
        if (pass == BiomeGenerator.EnumGeneratorPass.POST_GEN_CAVES && this.algaeNoise[x * 16 + z] / (double)1.6f * (double)(biomeWeight = biomeWeights.get(x, z)) + (double)1.8f <= 0.0) {
            int y = 120;
            Block currentBlock = chunkPrimer.func_177856_a(x, y, z).func_177230_c();
            Block blockAbove = chunkPrimer.func_177856_a(x, y + 1, z).func_177230_c();
            if (currentBlock == chunkGenerator.layerBlock && (blockAbove == null || blockAbove == Blocks.field_150350_a)) {
                chunkPrimer.func_177855_a(x, y + 1, z, BlockRegistry.ALGAE.func_176223_P());
            }
        }
    }
}

