/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import thebetweenlands.common.world.gen.feature.structure.utils.MazeGenerator;

public class PerfectMazeGenerator
implements MazeGenerator {
    private int[][] maze;
    private int width;
    private int height;
    private Random random;

    public PerfectMazeGenerator(int width, int height) {
        this.width = width;
        this.height = height;
        this.maze = new int[width][height];
        this.random = new Random();
    }

    @Override
    public int[][] generateMaze() {
        this.generateMaze(0, 0);
        return this.maze;
    }

    private void generateMaze(int cx, int cy) {
        MazeGenerator.Direction[] dirs = MazeGenerator.Direction.values();
        Collections.shuffle(Arrays.asList(dirs), this.random);
        for (MazeGenerator.Direction dir : dirs) {
            int nx = cx + dir.dx;
            int ny = cy + dir.dy;
            if (!PerfectMazeGenerator.between(nx, this.width) || !PerfectMazeGenerator.between(ny, this.height) || this.maze[nx][ny] != 0) continue;
            int[] nArray = this.maze[cx];
            int n = cy;
            nArray[n] = nArray[n] | dir.bit;
            int[] nArray2 = this.maze[nx];
            int n2 = ny;
            nArray2[n2] = nArray2[n2] | dir.opposite.bit;
            this.generateMaze(nx, ny);
        }
    }

    private static boolean between(int v, int upper) {
        return v >= 0 && v < upper;
    }
}

