/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.item.misc.ItemGemSinger;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.ChunkStorageImpl;

public class BetweenlandsChunkStorage
extends ChunkStorageImpl {
    private IntSet savedGemTargets = new IntOpenHashSet();
    private Int2ObjectMap<IntSet> gemToPositions = new Int2ObjectOpenHashMap();
    private boolean rescanGemSingerTargets = false;

    public BetweenlandsChunkStorage(IWorldStorage worldStorage, Chunk chunk) {
        super(worldStorage, chunk);
    }

    @Nullable
    public static BetweenlandsChunkStorage forChunk(World world, Chunk chunk) {
        ChunkStorageImpl chunkStorage;
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        if (worldStorage != null && (chunkStorage = worldStorage.getChunkStorage(chunk)) instanceof BetweenlandsChunkStorage) {
            return (BetweenlandsChunkStorage)chunkStorage;
        }
        return null;
    }

    @Override
    public void setDefaults() {
        for (ItemGemSinger.GemSingerTarget target : ItemGemSinger.GemSingerTarget.values()) {
            this.savedGemTargets.add(target.getId());
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean packet) {
        super.writeToNBT(nbt, packet);
        if (!packet) {
            nbt.func_74782_a("gemTargetTypes", (NBTBase)new NBTTagIntArray(this.savedGemTargets.toArray(new int[0])));
            NBTTagList gemToPositionsNbt = new NBTTagList();
            for (Int2ObjectMap.Entry entry : this.gemToPositions.int2ObjectEntrySet()) {
                NBTTagCompound targetNbt = new NBTTagCompound();
                targetNbt.func_74768_a("id", entry.getIntKey());
                targetNbt.func_74782_a("positions", (NBTBase)new NBTTagIntArray(((IntSet)entry.getValue()).toIntArray()));
                gemToPositionsNbt.func_74742_a((NBTBase)targetNbt);
            }
            nbt.func_74782_a("gemToPositions", (NBTBase)gemToPositionsNbt);
        }
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, boolean packet) {
        super.readFromNBT(nbt, packet);
        if (!packet) {
            int[] gemTargetTypes;
            this.savedGemTargets.clear();
            for (int target : gemTargetTypes = nbt.func_74759_k("gemTargetTypes")) {
                this.savedGemTargets.add(target);
            }
            if (this.world.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
                for (ItemGemSinger.GemSingerTarget target : ItemGemSinger.GemSingerTarget.values()) {
                    if (this.savedGemTargets.contains(target.getId())) continue;
                    this.rescanGemSingerTargets = true;
                    break;
                }
            }
            this.gemToPositions.clear();
            NBTTagList nBTTagList = nbt.func_150295_c("gemToPositions", 10);
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                NBTTagCompound targetNbt = nBTTagList.func_150305_b(i);
                int id = targetNbt.func_74762_e("id");
                int[] positions = targetNbt.func_74759_k("positions");
                this.gemToPositions.put(id, (Object)new IntArraySet(positions));
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.world.field_72995_K && this.rescanGemSingerTargets) {
            this.rescanGemSingerTargets = false;
            this.gemToPositions.clear();
            Chunk chunk = this.getChunk();
            int maxCheckY = Math.min(136, 255);
            for (int y = 0; y < maxCheckY; ++y) {
                for (int x = 0; x < 16; ++x) {
                    block2: for (int z = 0; z < 16; ++z) {
                        IBlockState state = chunk.func_186032_a(x, y, z);
                        for (ItemGemSinger.GemSingerTarget target : ItemGemSinger.GemSingerTarget.values()) {
                            if (!target.test(state)) continue;
                            IntSet indices = (IntSet)this.gemToPositions.get(target.getId());
                            if (indices == null) {
                                indices = new IntArraySet();
                                this.gemToPositions.put(target.getId(), (Object)indices);
                            }
                            indices.add(BetweenlandsChunkStorage.getGemSingerTargetIndex(x, y, z));
                            continue block2;
                        }
                    }
                }
            }
            for (ItemGemSinger.GemSingerTarget target : ItemGemSinger.GemSingerTarget.values()) {
                this.savedGemTargets.add(target.getId());
            }
            this.markDirty();
        }
    }

    public static int getGemSingerTargetIndex(int x, int y, int z) {
        return y << 8 | (z & 0xF) << 4 | x & 0xF;
    }

    public static BlockPos getGemSingerTargetPosition(int index) {
        return new BlockPos(index & 0xF, index >> 8 & 0xFF, index >> 4 & 0xF);
    }

    public boolean markGem(int x, int y, int z, ItemGemSinger.GemSingerTarget target) {
        IntSet indices = (IntSet)this.gemToPositions.get(target.getId());
        if (indices == null) {
            indices = new IntArraySet();
            this.gemToPositions.put(target.getId(), (Object)indices);
        }
        int index = BetweenlandsChunkStorage.getGemSingerTargetIndex(x & 0xF, y, z & 0xF);
        return indices.add(index);
    }

    public boolean unmarkGem(int x, int y, int z, ItemGemSinger.GemSingerTarget target) {
        IntSet indices = (IntSet)this.gemToPositions.get(target.getId());
        if (indices != null && indices.rem(BetweenlandsChunkStorage.getGemSingerTargetIndex(x & 0xF, y, z & 0xF))) {
            if (indices.isEmpty()) {
                this.gemToPositions.remove(target.getId());
            }
            return true;
        }
        return false;
    }

    public IntSet findGems(ItemGemSinger.GemSingerTarget target) {
        IntSet indices = (IntSet)this.gemToPositions.get(target.getId());
        if (indices != null) {
            return IntSets.unmodifiable((IntSet)indices);
        }
        return IntSets.EMPTY_SET;
    }

    @Nullable
    public BlockPos findRandomGem(ItemGemSinger.GemSingerTarget target, Random rand, BlockPos pos, float range) {
        BlockPos relPos = pos.func_177982_a(-this.getChunk().field_76635_g * 16, 0, -this.getChunk().field_76647_h * 16);
        IntSet indices = (IntSet)this.gemToPositions.get(target.getId());
        if (indices != null) {
            ArrayList<BlockPos> found = new ArrayList<BlockPos>();
            IntIterator intIterator = indices.iterator();
            while (intIterator.hasNext()) {
                int index = (Integer)intIterator.next();
                BlockPos gem = BetweenlandsChunkStorage.getGemSingerTargetPosition(index);
                if (!(gem.func_177951_i((Vec3i)relPos) <= (double)(range * range))) continue;
                found.add(gem);
            }
            if (!found.isEmpty()) {
                return ((BlockPos)found.get(rand.nextInt(found.size()))).func_177982_a(this.getChunk().field_76635_g * 16, 0, this.getChunk().field_76647_h * 16);
            }
        }
        return null;
    }

    public static boolean markGem(World world, BlockPos pos, ItemGemSinger.GemSingerTarget target) {
        BetweenlandsChunkStorage storage = BetweenlandsChunkStorage.forChunk(world, world.func_175726_f(pos));
        if (storage != null) {
            return storage.markGem(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), target);
        }
        return false;
    }

    public static boolean unmarkGem(World world, BlockPos pos, ItemGemSinger.GemSingerTarget target) {
        BetweenlandsChunkStorage storage = BetweenlandsChunkStorage.forChunk(world, world.func_175726_f(pos));
        if (storage != null) {
            return storage.unmarkGem(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), target);
        }
        return false;
    }

    @Nullable
    public static BlockPos findRandomGem(World world, ItemGemSinger.GemSingerTarget target, Random rand, BlockPos pos, float range) {
        BetweenlandsChunkStorage storage = BetweenlandsChunkStorage.forChunk(world, world.func_175726_f(pos));
        if (storage != null) {
            return storage.findRandomGem(target, rand, pos, range);
        }
        return null;
    }
}

