/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import org.apache.commons.io.FileUtils;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.world.storage.LocalRegionCache;

public class LocalRegionData {
    private String id;
    private NBTTagCompound nbt;
    private int refCounter;
    private boolean dirty;
    private final LocalRegionCache cache;

    public LocalRegionData(LocalRegionCache cache, String id, NBTTagCompound nbt) {
        this.id = id;
        this.nbt = nbt;
        this.refCounter = 0;
        this.dirty = false;
        this.cache = cache;
    }

    public String getID() {
        return this.id;
    }

    public void incrRefCounter() {
        ++this.refCounter;
    }

    public void decrRefCounter() {
        --this.refCounter;
    }

    public boolean hasReferences() {
        return this.refCounter > 0;
    }

    @Nullable
    public NBTTagCompound getLocalStorageNBT(StorageID id) {
        if (this.nbt.func_150297_b(id.getStringID(), 10)) {
            return this.nbt.func_74775_l(id.getStringID());
        }
        return null;
    }

    public void setLocalStorageNBT(StorageID id, NBTTagCompound nbt) {
        this.nbt.func_74782_a(id.getStringID(), (NBTBase)nbt);
        this.dirty = true;
    }

    public void deleteLocalStorage(File dir, StorageID id) {
        if (this.nbt.func_150297_b(id.getStringID(), 10)) {
            this.dirty = true;
            this.nbt.func_82580_o(id.getStringID());
            if (this.nbt.func_186856_d() == 0) {
                this.deleteRegionFile(dir);
            }
        }
    }

    public void setChunkNBT(ChunkPos chunk, NBTTagCompound nbt) {
        this.nbt.func_74782_a("ChunkData." + chunk.field_77276_a + "." + chunk.field_77275_b, (NBTBase)nbt);
        this.dirty = true;
    }

    @Nullable
    public NBTTagCompound getChunkNBT(ChunkPos chunk) {
        if (this.nbt.func_150297_b("ChunkData." + chunk.field_77276_a + "." + chunk.field_77275_b, 10)) {
            return this.nbt.func_74775_l("ChunkData." + chunk.field_77276_a + "." + chunk.field_77275_b);
        }
        return null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public static LocalRegionData getOrCreateRegion(LocalRegionCache cache, File dir, LocalRegion region) {
        NBTTagCompound regionNbt = null;
        File file = new File(dir, region.getFileName() + ".dat");
        try {
            regionNbt = cache.getLocalStorageHandler().getSaveHandler().loadFileNbt(file);
        }
        catch (Exception ex) {
            TheBetweenlands.logger.error("Failed loading local region cache", (Throwable)ex);
            File backup = new File(file.getAbsolutePath() + ".backup");
            try {
                FileUtils.copyFile((File)file, (File)backup);
                TheBetweenlands.logger.info(String.format("Created a backup of local region cache at %s", backup.getAbsolutePath()));
            }
            catch (IOException e) {
                TheBetweenlands.logger.error("Failed creating backup of local region cache", (Throwable)e);
            }
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            regionNbt = null;
        }
        if (regionNbt == null) {
            regionNbt = new NBTTagCompound();
        }
        return new LocalRegionData(cache, region.getFileName(), regionNbt);
    }

    public void saveRegion(File dir) {
        if (this.nbt.func_186856_d() > 0) {
            File file = new File(dir, this.getID() + ".dat");
            this.cache.getLocalStorageHandler().getSaveHandler().queueRegion(file, this.nbt.func_74737_b());
        } else {
            this.deleteRegionFile(dir);
        }
        this.dirty = false;
    }

    public void deleteRegionFile(File dir) {
        File file = new File(dir, this.getID() + ".dat");
        this.cache.getLocalStorageHandler().getSaveHandler().queueRegion(file, null);
    }
}

