/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public final class TimeMeasurement {
    private static final HashMap<String, Long> times = new HashMap();
    private static final HashMap<String, Counter> counters = new HashMap();

    public static void start(String id) {
        System.out.println("Started '" + id);
        times.put(id, System.nanoTime());
    }

    public static void finish(String id) {
        if (!times.containsKey(id)) {
            return;
        }
        long time = System.nanoTime() - times.remove(id);
        if (time >= 10000000L) {
            // empty if block
        }
        System.out.println("Finished '" + id + "' in " + time + " ns (" + TimeUnit.NANOSECONDS.toMillis(time) + " ms)");
        Counter counter = counters.get(id);
        if (counter == null) {
            counter = new Counter();
            counters.put(id, counter);
        }
        if (counter.add(time)) {
            counter.reset();
        }
    }

    private static final class Counter {
        private short counter;

        private Counter() {
        }

        public boolean add(long time) {
            this.counter = (short)(this.counter + 1);
            return this.counter > 256;
        }

        public void reset() {
            this.counter = 0;
        }
    }
}

