/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util.phys;

import java.util.Arrays;
import thebetweenlands.util.phys.DiffEqSolver;
import thebetweenlands.util.phys.Simulation;

public final class EulersSolver
implements DiffEqSolver {
    private final Simulation sim;
    private float[] inp = new float[0];
    private float[] k1 = new float[0];

    public EulersSolver(Simulation sim) {
        this.sim = sim;
    }

    @Override
    public void step(float stepSize) {
        float[] vars = this.sim.getState();
        int N = vars.length;
        if (this.inp.length < N) {
            this.inp = new float[N];
            this.k1 = new float[N];
        }
        float[] inp = this.inp;
        float[] k1 = this.k1;
        System.arraycopy(vars, 0, inp, 0, N);
        Arrays.fill(k1, 0.0f);
        this.sim.evaluate(inp, k1);
        for (int i = 0; i < N; ++i) {
            int n = i;
            vars[n] = vars[n] + k1[i] * stepSize;
        }
    }
}

