/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.block.entity.TileEntityBackpack;
import net.mcft.copy.backpacks.misc.util.LangUtils;
import net.mcft.copy.backpacks.misc.util.MiscUtils;
import net.mcft.copy.backpacks.misc.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBackpack
extends BlockContainer {
    public static final int EXPLOSION_RESIST_TICKS = 10;
    private final AxisAlignedBB[] _boundsFromFacing = new AxisAlignedBB[4];
    private long _lastHelpMessage = System.currentTimeMillis();

    public BlockBackpack() {
        super(Material.field_151580_n);
        this.func_149672_a(SoundType.field_185856_i);
        this.func_149711_c(1.5f);
        this.initBlockBounds();
    }

    public String func_149739_a() {
        return MiscUtils.getItemFromBlock((Block)this).func_77658_a();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBackpack();
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    protected float getBoundsWidth() {
        return 0.75f;
    }

    protected float getBoundsHeight() {
        return 0.8125f;
    }

    protected float getBoundsDepth() {
        return 0.625f;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity entity = source.func_175625_s(pos);
        EnumFacing facing = entity instanceof TileEntityBackpack ? ((TileEntityBackpack)entity).facing : EnumFacing.NORTH;
        return this._boundsFromFacing[facing.ordinal() - 2];
    }

    private void initBlockBounds() {
        float w = this.getBoundsWidth();
        float h = this.getBoundsHeight();
        float d = this.getBoundsDepth();
        for (int i = 0; i < this._boundsFromFacing.length; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)(i + 2));
            this._boundsFromFacing[i] = facing.func_176740_k() == EnumFacing.Axis.Z ? new AxisAlignedBB((double)(0.5f - w / 2.0f), 0.0, (double)(0.5f - d / 2.0f), (double)(0.5f + w / 2.0f), (double)h, (double)(0.5f + d / 2.0f)) : new AxisAlignedBB((double)(0.5f - d / 2.0f), 0.0, (double)(0.5f - w / 2.0f), (double)(0.5f + d / 2.0f), (double)h, (double)(0.5f + w / 2.0f));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IBackpack backpack = BackpackHelper.getBackpack(world.func_175625_s(pos));
        return backpack != null ? backpack.getStack().func_77946_l() : super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityBackpack) {
            ((TileEntityBackpack)tileEntity).facing = placer.func_174811_aO();
        }
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        float hardness = super.func_180647_a(state, player, worldIn, pos);
        boolean sneaking = player.func_70093_af();
        boolean canEquip = BackpackHelper.canEquipBackpack((EntityLivingBase)player);
        return sneaking && !canEquip ? -1.0f : hardness * (float)(sneaking ? 4 : 1);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K && player.func_70093_af() && !BackpackHelper.canEquipBackpack((EntityLivingBase)player) && System.currentTimeMillis() > this._lastHelpMessage + 10000L) {
            boolean backpack = BackpackHelper.getBackpack((Entity)player) != null;
            LangUtils.displayChatMessage("cantEquip" + (!backpack ? ".chestplate" : ""), new Object[0]);
            this._lastHelpMessage = System.currentTimeMillis();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity entity = worldIn.func_175625_s(pos);
        IBackpack backpack = BackpackHelper.getBackpack(entity);
        if (backpack != null) {
            backpack.getType().onPlacedInteract(player, entity, backpack);
        }
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K && player.func_70093_af() && BackpackHelper.canEquipBackpack((EntityLivingBase)player)) {
            BackpackHelper.equipBackpack((EntityLivingBase)player, worldIn.func_175625_s(pos));
        }
    }

    protected void dropBackpack(World worldIn, BlockPos pos) {
        this.dropBackpack(worldIn, pos, worldIn.func_175625_s(pos));
    }

    protected void dropBackpack(World worldIn, BlockPos pos, TileEntity entity) {
        IBackpack backpack;
        if (!worldIn.field_72995_K && (backpack = BackpackHelper.getBackpack(entity)) != null && backpack.getType() != null && !backpack.getStack().func_190926_b()) {
            backpack.getType().onBlockBreak(entity, backpack);
            WorldUtils.dropStackFromBlock(worldIn, pos, backpack.getStack());
        }
    }

    protected boolean preventExplosionDestroy(World world, BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        return entity instanceof TileEntityBackpack && ((TileEntityBackpack)entity).getAge() < 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!this.preventExplosionDestroy(world, pos) && chance > 0.0f) {
            this.dropBackpack(world, pos);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        this.harvesters.set(player);
        this.dropBackpack(worldIn, pos, te);
        this.harvesters.set(null);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.preventExplosionDestroy(world, pos)) {
            return;
        }
        super.onBlockExploded(world, pos, explosion);
    }
}

