/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui;

import java.io.File;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class GuiEntityRender
extends GuiElementBase {
    private static final int RESERVED_SPACE = 16;
    private Entity _entity = null;
    private float _yawDefault = 0.0f;
    private float _yaw = 0.0f;
    private float _yawMin = -180.0f;
    private float _yawMax = 180.0f;
    private float _pitchDefault = 0.0f;
    private float _pitch = 15.0f;
    private float _pitchMin = -25.0f;
    private float _pitchMax = 25.0f;
    private float _centerX = 0.5f;
    private float _centerY = 0.5f;
    private float _zoom = 1.0f;
    private int _colorBackground = GuiElementBase.Color.BLACK;
    private int _colorBorder = -6250336;

    public GuiEntityRender(Entity entity) {
        this(80, 140, entity);
    }

    public GuiEntityRender(int width, int height) {
        this(width, height, (Entity)null);
    }

    public GuiEntityRender(int width, int height, Entity entity) {
        this(0, 0, width, height, entity);
    }

    public GuiEntityRender(int x, int y, int width, int height, Entity entity) {
        this.setPosition(x, y);
        this.setSize(width, height);
        this.setEntity(entity);
    }

    public GuiEntityRender(Class<? extends Entity> entityClass) {
        this(80, 140, entityClass);
    }

    public GuiEntityRender(int width, int height, Class<? extends Entity> entityClass) {
        this(0, 0, width, height, entityClass);
    }

    public GuiEntityRender(int x, int y, int width, int height, Class<? extends Entity> entityClass) {
        this.setPosition(x, y);
        this.setSize(width, height);
        this.setEntity(entityClass);
    }

    public Entity getEntity() {
        return this._entity;
    }

    public void setEntity(Entity value) {
        this._entity = value;
    }

    public void setEntity(Class<? extends Entity> value) {
        try {
            this.setEntity(value != null ? value.getConstructor(World.class).newInstance(new Object[]{DummyWorld.INSTANCE}) : null);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setYaw(float value, float min, float max) {
        this.setYaw(value);
        this.setYawControl(min, max);
    }

    public void setYaw(float value) {
        this._yawDefault = value;
    }

    public void setYawControl(float min, float max) {
        this._yawMin = min;
        this._yawMax = max;
    }

    public void setPitch(float value, float min, float max) {
        this.setPitch(value);
        this.setPitchControl(min, max);
    }

    public void setPitch(float value) {
        this._pitchDefault = value;
    }

    public void setPitchControl(float min, float max) {
        this._pitchMin = min;
        this._pitchMax = max;
    }

    public void setCenter(float x, float y) {
        this._centerX = x;
        this._centerY = y;
    }

    public void setZoom(float value) {
        this._zoom = value;
    }

    public void setBackgroundColor(int value) {
        this._colorBackground = value;
    }

    public void setBorderColor(int value) {
        this._colorBorder = value;
    }

    @Override
    public boolean canDrag() {
        return true;
    }

    @Override
    public void onDragged(int mouseX, int mouseY, int deltaX, int deltaY, int startX, int startY) {
        boolean pitchWrap;
        this._yaw += (float)(deltaX * 2);
        this._pitch += (float)deltaY;
        boolean yawWrap = this._yawMax - this._yawMin >= 360.0f;
        boolean bl = pitchWrap = this._pitchMax - this._pitchMin >= 360.0f;
        if (this._yaw < this._yawMin) {
            float f = this._yaw = yawWrap ? this._yaw + 360.0f : this._yawMin;
        }
        if (this._yaw > this._yawMax) {
            float f = this._yaw = yawWrap ? this._yaw - 360.0f : this._yawMax;
        }
        if (this._pitch < this._pitchMin) {
            float f = this._pitch = pitchWrap ? this._pitch + 360.0f : this._pitchMin;
        }
        if (this._pitch > this._pitchMax) {
            this._pitch = pitchWrap ? this._pitch - 360.0f : this._pitchMax;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        int w = this.getWidth();
        int h = this.getHeight();
        GuiEntityRender.enableBlendAlphaStuffs();
        GuiEntityRender.setRenderColorARGB(this._colorBackground);
        GuiEntityRender.drawRect(1, 1, w - 2, h - 2);
        GuiEntityRender.setRenderColorARGB(this._colorBorder);
        GuiEntityRender.drawOutline(0, 0, w, h);
        GuiEntityRender.disableBlendAlphaStuffs();
        Entity entity = this.getEntity();
        if (entity == null) {
            return;
        }
        AxisAlignedBB bbox = entity.func_184177_bl();
        float entityWidth = (float)(bbox.field_72336_d - bbox.field_72340_a);
        float entityHeight = (float)(bbox.field_72337_e - bbox.field_72338_b);
        float scale = Math.min((float)(w - 16) / entityWidth, (float)(h - 16) / entityHeight) * this._zoom;
        float yaw = this._yawDefault + this._yaw;
        float pitch = this._pitchDefault + this._pitch;
        this.getContext().pushScissor(this, 1, 1, w - 2, h - 2);
        if (entity.func_130014_f_() == null) {
            entity.func_70029_a((World)DummyWorld.INSTANCE);
        }
        if (GuiEntityRender.getMC().field_71439_g == null) {
            World world = entity.func_130014_f_();
            if (!(world instanceof DummyWorld)) {
                return;
            }
            GuiEntityRender.getMC().field_71439_g = ((DummyWorld)world).player;
            GuiEntityRender.getMC().field_71439_g.func_70029_a(world);
        }
        GuiEntityRender.setRenderColorARGB(GuiElementBase.Color.WHITE);
        GlStateManager.func_179126_j();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)w * this._centerX), (float)((float)h * this._centerY), (float)100.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-(entityHeight / 2.0f)), (float)0.0f);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179097_i();
        if (GuiEntityRender.getMC().field_71439_g instanceof DummyPlayerSP) {
            GuiEntityRender.getMC().field_71439_g = null;
        }
        this.getContext().popScissor();
    }

    public static class DummyPlayerSP
    extends EntityPlayerSP {
        public DummyPlayerSP(World world) {
            super(GuiElementBase.getMC(), world, new NetHandlerPlayClient(GuiElementBase.getMC(), null, null, GuiElementBase.getMC().func_110432_I().func_148256_e()), null, null);
        }
    }

    public static class DummySaveHandler
    implements ISaveHandler {
        public WorldInfo func_75757_d() {
            return null;
        }

        public void func_75762_c() throws MinecraftException {
        }

        public IChunkLoader func_75763_a(WorldProvider provider) {
            return null;
        }

        public void func_75755_a(WorldInfo worldInformation, NBTTagCompound tagCompound) {
        }

        public void func_75761_a(WorldInfo worldInformation) {
        }

        public IPlayerFileData func_75756_e() {
            return null;
        }

        public void func_75759_a() {
        }

        public File func_75765_b() {
            return null;
        }

        public File func_75758_b(String mapName) {
            return null;
        }

        public TemplateManager func_186340_h() {
            return null;
        }
    }

    public static class DummyWorld
    extends World {
        public static final DummyWorld INSTANCE = new DummyWorld();
        public final DummyPlayerSP player;

        public DummyWorld() {
            this(new WorldSettings(0L, GameType.SURVIVAL, false, false, WorldType.field_77137_b));
        }

        public DummyWorld(WorldSettings settings) {
            super((ISaveHandler)new DummySaveHandler(), new WorldInfo(settings, "DummyWorld"), (WorldProvider)new WorldProviderSurface(), null, true);
            this.field_73011_w.func_76558_a((World)this);
            this.player = new DummyPlayerSP(this);
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
            return false;
        }

        public Chunk func_72964_e(int chunkX, int chunkZ) {
            return null;
        }

        public boolean func_175677_d(BlockPos pos, boolean _default) {
            return false;
        }

        public Biome getBiomeForCoordsBody(BlockPos pos) {
            return Biomes.field_180279_ad;
        }

        public boolean func_175678_i(BlockPos pos) {
            return true;
        }

        public int func_175699_k(BlockPos pos) {
            return 15;
        }

        public int func_175721_c(BlockPos pos, boolean checkNeighbors) {
            return 15;
        }

        public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
            return 15;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }
}

