/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui;

import net.mcft.copy.backpacks.client.gui.Alignment;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.GuiContainer;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLayout
extends GuiContainer {
    public final Direction direction;
    private int[] _spacing = new int[]{2};

    public GuiLayout(Direction direction) {
        this.direction = direction;
    }

    public int[] getSpacing() {
        return this._spacing;
    }

    public void setSpacing(int ... value) {
        this._spacing = value;
    }

    public GuiElementBase get(int index) {
        return (GuiElementBase)this.children.get(index);
    }

    @Override
    public void add(GuiElementBase element) {
        this.addWeighted(element);
    }

    public void addFixed(GuiElementBase element, int size) {
        this.insertFixed(this.children.size(), element, size);
    }

    public void addFixed(GuiElementBase element) {
        this.insertFixed(this.children.size(), element);
    }

    public void addWeighted(GuiElementBase element) {
        this.insertWeighted(this.children.size(), element);
    }

    public void addWeighted(GuiElementBase element, double weight) {
        this.insertWeighted(this.children.size(), element, weight);
    }

    public void addWeighted(GuiElementBase element, double weight, int minSize) {
        this.insertWeighted(this.children.size(), element, weight, minSize);
    }

    public void insertFixed(int index, GuiElementBase element, int size) {
        element.setSize(this.direction, size);
        this.insertFixed(index, element);
    }

    public void insertFixed(int index, GuiElementBase element) {
        this.insert(index, element, new LayoutAlignment.Fixed());
    }

    public void insertWeighted(int index, GuiElementBase element) {
        this.insertWeighted(index, element, 1.0);
    }

    public void insertWeighted(int index, GuiElementBase element, double weight) {
        this.insertWeighted(index, element, weight, 0);
    }

    public void insertWeighted(int index, GuiElementBase element, double weight, int minSize) {
        this.insert(index, element, new LayoutAlignment.Weighted(weight, minSize));
    }

    protected void insert(int index, GuiElementBase element, LayoutAlignment alignment) {
        if (element.getContext() != null) {
            throw new UnsupportedOperationException("The specified element already has a context set");
        }
        element.setAlign(this.direction, (Alignment)alignment);
        super.insert(index, element);
    }

    @Override
    public void onChildSizeChanged(GuiElementBase element, Direction direction) {
        super.onChildSizeChanged(element, direction);
        if (direction == this.direction) {
            this.updateChildSizes(direction);
        }
    }

    @Override
    public void onChildAlignChanged(GuiElementBase element, Direction direction) {
        if (direction == this.direction && !(this.getAlign(direction) instanceof LayoutAlignment)) {
            throw new UnsupportedOperationException("Unsupported Alignment '" + this.getAlign(direction).getClass() + "' in GuiLayout");
        }
        super.onChildAlignChanged(element, direction);
    }

    @Override
    public int getChildPos(GuiElementBase element, Direction direction) {
        return direction == this.direction ? this.getPaddingMin(direction) + ((LayoutAlignment)element.getAlign(direction))._childPos : super.getChildPos(element, direction);
    }

    @Override
    protected void updateChildSizes(Direction direction) {
        if (direction != this.direction) {
            super.updateChildSizes(direction);
            return;
        }
        int[] spacing = this.getSpacing();
        double remainingWeight = 0.0;
        int availableSize = this.getSize(direction) - this.getPadding(direction);
        for (int i = 0; i < this.children.size(); ++i) {
            GuiElementBase child = (GuiElementBase)this.children.get(i);
            Alignment align = child.getAlign(direction);
            if (align instanceof LayoutAlignment.Weighted) {
                LayoutAlignment.Weighted weighted = (LayoutAlignment.Weighted)align;
                remainingWeight += weighted.weight;
                availableSize -= weighted.minSize;
            } else {
                availableSize -= child.getSize(direction);
            }
            if (i >= this.children.size() - 1) continue;
            availableSize -= spacing[Math.min(spacing.length - 1, i)];
        }
        int currentPos = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            GuiElementBase child = (GuiElementBase)this.children.get(i);
            int size = 0;
            LayoutAlignment align = (LayoutAlignment)child.getAlign(direction);
            if (align instanceof LayoutAlignment.Weighted) {
                LayoutAlignment.Weighted weighted = (LayoutAlignment.Weighted)align;
                size = Math.max(0, (int)((double)availableSize * weighted.weight / remainingWeight));
                remainingWeight -= weighted.weight;
                availableSize -= size;
                child.setSize(direction, size += weighted.minSize);
            } else {
                size = child.getSize(direction);
            }
            align._childPos = currentPos;
            currentPos += size;
            if (i >= this.children.size() - 1) continue;
            currentPos += spacing[Math.min(spacing.length - 1, i)];
        }
        if (this.doesExpand(direction)) {
            this.setSize(direction, currentPos + this.getPadding(direction));
        }
    }

    public static abstract class LayoutAlignment
    extends Alignment {
        private int _childPos;

        private LayoutAlignment() {
        }

        public static final class Weighted
        extends LayoutAlignment {
            public final double weight;
            public final int minSize;

            public Weighted(double weight, int minSize) {
                this.weight = weight;
                this.minSize = minSize;
            }

            @Override
            public boolean canExpand() {
                return false;
            }
        }

        public static final class Fixed
        extends LayoutAlignment {
        }
    }
}

