/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui;

import java.util.EnumSet;
import net.mcft.copy.backpacks.client.gui.Alignment;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.ElementInfo;
import net.mcft.copy.backpacks.client.gui.GuiContainer;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.mcft.copy.backpacks.client.gui.control.GuiSlider;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScrollable
extends GuiContainer {
    private static final int GRADIENT_SIZE = 4;
    public final EnumSet<Direction> directions;
    private GuiScrollbar _scrollbarHor;
    private GuiScrollbar _scrollbarVer;
    private int _scrollAmount = 10;
    private int _scrollX = 0;
    private int _scrollY = 0;
    private int _scrollStartX;
    private int _scrollStartY;
    private int _contentWidth = 0;
    private int _contentHeight = 0;
    private int _contentWidthExtra = 0;
    private int _contentHeightExtra = 0;

    public GuiScrollable() {
        this(EnumSet.allOf(Direction.class));
    }

    public GuiScrollable(Direction direction) {
        this(EnumSet.of(direction));
    }

    public GuiScrollable(EnumSet<Direction> directions) {
        if (directions.isEmpty()) {
            throw new IllegalArgumentException("Argument 'directions' must be at least one Direction");
        }
        this.directions = directions;
        for (Direction direction : directions) {
            GuiScrollbar scrollbar = new GuiScrollbar(direction);
            if (direction == Direction.HORIZONTAL) {
                this._scrollbarHor = scrollbar;
            } else {
                this._scrollbarVer = scrollbar;
            }
            this.add(scrollbar);
        }
    }

    public GuiScrollbar getScrollbar(Direction direction) {
        return direction == Direction.HORIZONTAL ? this._scrollbarHor : this._scrollbarVer;
    }

    public final GuiScrollbar getScrollbar() {
        if (this.directions.size() != 1) {
            throw new UnsupportedOperationException("Element slides in both directions");
        }
        return this.getScrollbar((Direction)((Object)this.directions.iterator().next()));
    }

    public int getScroll(Direction direction) {
        return direction == Direction.HORIZONTAL ? this._scrollX : this._scrollY;
    }

    public final int getScrollX() {
        return this.getScroll(Direction.HORIZONTAL);
    }

    public final int getScrollY() {
        return this.getScroll(Direction.VERTICAL);
    }

    public void setScroll(Direction direction, int value) {
        value = MathHelper.func_76125_a((int)value, (int)0, (int)this.getMaxScroll(direction));
        if (direction == Direction.HORIZONTAL) {
            if (value == this._scrollX) {
                return;
            }
            this._scrollX = value;
        } else {
            if (value == this._scrollY) {
                return;
            }
            this._scrollY = value;
        }
        this.onScrollChanged(direction);
    }

    public final void setScrollX(int value) {
        this.setScroll(Direction.HORIZONTAL, value);
    }

    public final void setScrollY(int value) {
        this.setScroll(Direction.VERTICAL, value);
    }

    public int getMaxScroll(Direction direction) {
        return Math.max(0, this.getContentSize(direction) - this.getSize(direction));
    }

    public int getContentSize(Direction direction) {
        return this.getContentSize(direction, false);
    }

    public int getContentSize(Direction direction, boolean withoutPadding) {
        int size;
        int n = size = direction == Direction.HORIZONTAL ? this._contentWidth : this._contentHeight;
        if (!withoutPadding) {
            size += direction == Direction.HORIZONTAL ? this._contentWidthExtra : this._contentHeightExtra;
        }
        return size;
    }

    protected void onScrollChanged(Direction direction) {
    }

    @Override
    public boolean canDrag() {
        return true;
    }

    @Override
    public void onPressed(int mouseX, int mouseY) {
        this._scrollStartX = this._scrollX;
        this._scrollStartY = this._scrollY;
    }

    @Override
    public void onDragged(int mouseX, int mouseY, int deltaX, int deltaY, int startX, int startY) {
        this.setScrollX(this._scrollStartX + (startX - mouseX));
        this.setScrollY(this._scrollStartY + (startY - mouseY));
    }

    @Override
    public boolean onMouseScroll(int scroll, int mouseX, int mouseY) {
        if (this.isDragged()) {
            return false;
        }
        if (super.onMouseScroll(scroll, mouseX, mouseY)) {
            return true;
        }
        this.setScrollY(this.getScrollY() - scroll * this._scrollAmount);
        return true;
    }

    @Override
    public int getChildPos(GuiElementBase element, Direction direction) {
        return this.getChildPos(element, direction, true);
    }

    protected int getChildPos(GuiElementBase element, Direction direction, boolean scroll) {
        int scrollAmount;
        Alignment align = element.getAlign(direction);
        int n = scrollAmount = scroll ? this.getScroll(direction) : 0;
        return align instanceof ContentMax ? Math.min(this.getSize(direction) - element.getSize(direction), this.getContentSize(direction, true) + ((ContentMax)align).margin) : (align instanceof Alignment.Max ? (align instanceof FixedMax ? this.getSize(direction) : this.getContentSize(direction) - scrollAmount - this.getPaddingMax(direction)) - element.getSize(direction) - ((Alignment.Max)align).max : (align instanceof IFixedAlign ? super.getChildPos(element, direction) - this.getPaddingMin(direction) : super.getChildPos(element, direction) - scrollAmount));
    }

    @Override
    protected void updateChildSizes(Direction direction) {
        for (GuiElementBase child : this.children) {
            Alignment align = child.getAlign(direction);
            if (!(align instanceof Alignment.Both)) continue;
            Alignment.Both both = (Alignment.Both)align;
            int size = both instanceof FixedBoth ? this.getSize(direction) : this.getContentSize(direction);
            child.setSize(direction, size - both.min - both.max);
        }
    }

    @Override
    protected void expandToFitChildren(Direction direction) {
        int max = 0;
        int extra = 0;
        for (GuiElementBase child : this.children) {
            Alignment align = child.getAlign(direction);
            if (align instanceof ContentMax) {
                extra = Math.max(extra, ((ContentMax)align).margin + child.getSize(direction));
                continue;
            }
            if (align instanceof Alignment.Both) continue;
            max = Math.max(max, this.getChildPos(child, direction, false) - this.getPaddingMin(direction) + child.getSize(direction));
        }
        if (direction == Direction.HORIZONTAL) {
            this._contentWidth = max;
        } else {
            this._contentHeight = max;
        }
        extra += this.getPadding(direction);
        if (direction == Direction.HORIZONTAL) {
            this._contentWidthExtra = extra;
        } else {
            this._contentHeightExtra = extra;
        }
        if (this.getScroll(direction) > this.getMaxScroll(direction)) {
            this.setScroll(direction, this.getMaxScroll(direction));
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        ElementInfo info = ElementInfo.getElementHierarchy(this).getFirst();
        this.getContext().pushScissor(info.globalX, info.globalY, this.getWidth(), this.getHeight());
        this.drawBackground(info.globalX + this.getScrollX(), info.globalY + this.getScrollY(), mouseX, mouseY, partialTicks);
        this.foreachChildMousePos(mouseX, mouseY, (child, x, y, mx, my) -> {
            if (child instanceof GuiScrollbar) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            child.draw(mx, my, partialTicks);
            GlStateManager.func_179121_F();
        });
        this.drawForeground(mouseX, mouseY, partialTicks);
        this.getContext().popScissor();
    }

    public void drawBackground(int x, int y, int mouseX, int mouseY, float partialTicks) {
        float scale = 0.03125f;
        float u1 = (float)x * scale;
        float v1 = (float)y * scale;
        float u2 = (float)(x + this.getWidth()) * scale;
        float v2 = (float)(y + this.getHeight()) * scale;
        GuiScrollable.bindTexture(Gui.field_110325_k);
        GuiScrollable.setRenderColorRGB(0x202020);
        GuiScrollable.drawRect(0, 0, this.getWidth(), this.getHeight(), u1, v1, u2, v2);
    }

    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        GuiScrollable.enableBlendAlphaStuffs();
        if (this.directions.contains((Object)Direction.VERTICAL)) {
            GuiScrollable.drawColoredRectARGB(0, 0, this.getWidth(), 4, GuiElementBase.Color.BLACK, GuiElementBase.Color.BLACK, GuiElementBase.Color.TRANSPARENT, GuiElementBase.Color.TRANSPARENT);
            GuiScrollable.drawColoredRectARGB(0, this.getHeight() - 4, this.getWidth(), 4, GuiElementBase.Color.TRANSPARENT, GuiElementBase.Color.TRANSPARENT, GuiElementBase.Color.BLACK, GuiElementBase.Color.BLACK);
        }
        if (this.directions.contains((Object)Direction.HORIZONTAL)) {
            GuiScrollable.drawColoredRectARGB(0, 0, 4, this.getHeight(), GuiElementBase.Color.BLACK, GuiElementBase.Color.TRANSPARENT, GuiElementBase.Color.BLACK, GuiElementBase.Color.TRANSPARENT);
            GuiScrollable.drawColoredRectARGB(this.getWidth() - 4, 0, 4, this.getHeight(), GuiElementBase.Color.BLACK, GuiElementBase.Color.TRANSPARENT, GuiElementBase.Color.BLACK, GuiElementBase.Color.TRANSPARENT);
        }
        GuiScrollable.disableBlendAlphaStuffs();
        this.foreachChildMousePos(mouseX, mouseY, (child, x, y, mx, my) -> {
            if (!(child instanceof GuiScrollbar)) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            child.draw(mx, my, partialTicks);
            GlStateManager.func_179121_F();
        });
    }

    public static class ContentMax
    extends Alignment {
        public final int margin;

        public ContentMax(int margin) {
            this.margin = margin;
        }
    }

    public static class FixedBoth
    extends Alignment.Both
    implements IFixedAlign {
        public FixedBoth(int min, int max) {
            super(min, max);
        }
    }

    public static class FixedMax
    extends Alignment.Max
    implements IFixedAlign {
        public FixedMax(int max) {
            super(max);
        }
    }

    public static class FixedMin
    extends Alignment.Min
    implements IFixedAlign {
        public FixedMin(int min) {
            super(min);
        }
    }

    public static interface IFixedAlign {
    }

    public class GuiScrollbar
    extends GuiSlider {
        public static final int THICKNESS = 6;
        public final Direction direction;
        private int _scrollStart;

        private GuiScrollbar(Direction direction) {
            super(0, 0, direction == Direction.HORIZONTAL ? 200 : 6, direction == Direction.VERTICAL ? 200 : 6, direction);
            this.direction = direction;
            this.setAlign(direction, (Alignment)new FixedBoth(0, 0));
            this.setAlign(direction.perpendicular(), (Alignment)new FixedMax(0));
            this.setSliderRaw(0.0);
        }

        @Override
        public int getSliderSize() {
            return MathHelper.func_76125_a((int)((int)Math.pow(GuiScrollable.this.getSize(this.direction), 2.0) / GuiScrollable.this.getContentSize(this.direction)), (int)32, (int)(this.getSize(this.direction) - 8));
        }

        @Override
        public double getSliderRaw(Direction direction) {
            return (double)GuiScrollable.this.getScroll(direction) / (double)GuiScrollable.this.getMaxScroll(direction);
        }

        @Override
        public void onPressed(int mouseX, int mouseY) {
            this._scrollStart = GuiScrollable.this.getScroll(this.direction);
            super.onPressed(mouseX, mouseY);
        }

        @Override
        public void onDragged(int mouseX, int mouseY, int deltaX, int deltaY, int startX, int startY) {
            int diff = this.direction == Direction.HORIZONTAL ? mouseX - startX : mouseY - startY;
            double scrollFactor = (double)(this.getSize(this.direction) - this.getSliderSize()) / (double)Math.max(1, GuiScrollable.this.getMaxScroll(this.direction));
            GuiScrollable.this.setScroll(this.direction, this._scrollStart + (int)((double)diff / scrollFactor));
        }

        @Override
        public String getValueText() {
            return "";
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks) {
            int h;
            int w;
            int y;
            int x;
            if (!this.isVisible() || GuiScrollable.this.getMaxScroll(this.direction) == 0) {
                return;
            }
            int sliderSize = this.getSliderSize();
            int sliderPosition = (int)(this.getSliderRaw() * (double)(this.getSize(this.direction) - sliderSize));
            if (this.direction == Direction.HORIZONTAL) {
                x = sliderPosition;
                y = 0;
                w = sliderSize;
                h = this.getHeight();
            } else {
                x = 0;
                y = sliderPosition;
                w = this.getWidth();
                h = sliderSize;
            }
            GlStateManager.func_179090_x();
            GuiScrollbar.drawColoredRectRGB(0, 0, this.getWidth(), this.getHeight(), GuiElementBase.Color.BLACK);
            GuiScrollbar.drawColoredRectRGB(x, y, w, h, 0x808080);
            GuiScrollbar.drawColoredRectRGB(x, y, w - 1, h - 1, 0xC0C0C0);
            GlStateManager.func_179098_w();
        }
    }
}

