/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.mcft.copy.backpacks.client.gui.GuiLabel;
import net.mcft.copy.backpacks.client.gui.GuiLayout;
import net.mcft.copy.backpacks.client.gui.config.BaseConfigScreen;
import net.mcft.copy.backpacks.client.gui.config.BaseEntry;
import net.mcft.copy.backpacks.client.gui.config.BaseEntryList;
import net.mcft.copy.backpacks.client.gui.config.EntryValueField;
import net.mcft.copy.backpacks.client.gui.config.IConfigEntry;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.client.gui.config.custom.EntryListEntities;
import net.mcft.copy.backpacks.client.gui.config.custom.ScreenRenderOptions;
import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.mcft.copy.backpacks.client.gui.control.GuiButtonIcon;
import net.mcft.copy.backpacks.client.gui.control.GuiField;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.Status;
import net.mcft.copy.backpacks.item.ItemBackpack;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ScreenEntityEntry
extends BaseConfigScreen {
    public static final long UPDATE_TIMESPAN = 1600L;
    private final EntryListEntities _owningList;
    private final Optional<EntryListEntities.Entry> _entry;
    public final EntryEntityID entryEntityID;
    public final EntryButtonRenderOptions entryRenderOptions;
    public final EntryListBackpack listBackpack;
    public final GuiButton buttonCancel;
    public final boolean isDefault;

    public ScreenEntityEntry(EntryListEntities owningList, Optional<EntryListEntities.Entry> entry) {
        super(GuiElementBase.getCurrentScreen(), (String[])Stream.concat(((BaseConfigScreen)GuiElementBase.getCurrentScreen()).getTitleLines().stream().skip(1L), Stream.of("< this is where the entity name will go >")).toArray(String[]::new));
        this._owningList = owningList;
        this._entry = entry;
        Optional<BackpackRegistry.BackpackEntityEntry> backpackEntry = entry.map(EntryListEntities.Entry::getValue);
        this.isDefault = backpackEntry.map(e -> e.isDefault).orElse(false);
        List entries = backpackEntry.map(BackpackRegistry.BackpackEntityEntry::getEntries).orElseGet(Collections::emptyList);
        List<BackpackRegistry.BackpackEntry> defaults = entries.stream().filter(e -> e.isDefault).collect(Collectors.toList());
        this.entryEntityID = new EntryEntityID(this);
        this.entryRenderOptions = new EntryButtonRenderOptions(this.entryEntityID, this._entry.map(e -> e.getValue().renderOptions), this::getBackpackEntries);
        this.entryRenderOptions.setLabelAndTooltip("entity.renderOptions");
        this.listBackpack = new EntryListBackpack(defaults, entries);
        this.listEntries.addFixed(this.entryEntityID);
        this.listEntries.addFixed(this.entryRenderOptions);
        this.listEntries.addFixed(this.listBackpack);
        if (this.isDefault) {
            this.entryEntityID.setEnabled(false);
            this.entryRenderOptions.setEnabled(false);
        }
        this.buttonCancel = new GuiButton(I18n.func_135052_a((String)"config.wearablebackpacks.gui.cancel", (Object[])new Object[0]));
        if (this.buttonCancel.getWidth() < 100) {
            this.buttonCancel.setWidth(100);
        }
        this.buttonCancel.setAction(this::cancelClicked);
        this.layoutButtons.addFixed(this.buttonDone);
        if (entry.isPresent()) {
            this.layoutButtons.addFixed(this.buttonUndo);
            if (!defaults.isEmpty()) {
                this.layoutButtons.addFixed(this.buttonReset);
            }
        } else {
            this.layoutButtons.addFixed(this.buttonCancel);
        }
    }

    private List<BackpackRegistry.BackpackEntry> getBackpackEntries() {
        List backpacks = this.listBackpack.getEntries().map(e -> (BackpackRegistry.BackpackEntry)e.getValue()).filter(e -> Item.func_111206_d((String)e.backpack) != null).collect(Collectors.toCollection(ArrayList::new));
        if (backpacks.isEmpty()) {
            backpacks.add(BackpackRegistry.BackpackEntry.DEFAULT);
        }
        return backpacks;
    }

    @Override
    protected void doneClicked() {
        BackpackRegistry.BackpackEntityEntry value = new BackpackRegistry.BackpackEntityEntry((String)this.entryEntityID.getValue().get(), this.entryRenderOptions.getValue().get(), this.listBackpack.getValue(), this.isDefault);
        this._entry.orElseGet(() -> (EntryListEntities.Entry)this._owningList.addEntry()).setValue(value);
        GuiElementBase.display(this.parentScreen);
    }

    protected void cancelClicked() {
        GuiElementBase.display(this.parentScreen);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.buttonDone.setEnabled(this.listEntries.getEntries().allMatch(IConfigEntry::isValid));
        this.buttonUndo.setEnabled(this.listEntries.getEntries().anyMatch(IConfigEntry::isChanged));
        this.buttonReset.setEnabled(!this.listEntries.getEntries().allMatch(IConfigEntry::isDefault));
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public static class EntryListBackpack
    extends BaseEntryList<BackpackRegistry.BackpackEntry> {
        public static final int CHANCE_WIDTH = 42;

        public EntryListBackpack(List<BackpackRegistry.BackpackEntry> defaultValue, List<BackpackRegistry.BackpackEntry> previousValue) {
            super(300, defaultValue, previousValue);
            GuiLayout entryHeader = new GuiLayout(Direction.HORIZONTAL);
            entryHeader.setFillHorizontal();
            entryHeader.setHeight(18);
            entryHeader.setPaddingHorizontal(4, 40);
            entryHeader.setSpacing(9, 2);
            entryHeader.addFixed(EntryListBackpack.createLabel("entity.chance"), 62);
            entryHeader.addWeighted(EntryListBackpack.createLabel("entity.backpack"));
            entryHeader.addWeighted(EntryListBackpack.createLabel("entity.lootTable"));
            this.insertFixed(0, entryHeader);
        }

        private static GuiLabel createLabel(String key) {
            key = "config.wearablebackpacks." + key;
            GuiLabel label = new GuiLabel(I18n.func_135052_a((String)key, (Object[])new Object[0]), GuiLabel.TextAlign.CENTER);
            label.setTooltip(Arrays.asList(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]).split("\\n")));
            label.setBottom(2);
            return label;
        }

        @Override
        protected BaseEntryList.Entry<BackpackRegistry.BackpackEntry> createListEntry() {
            return new Entry(this);
        }

        @Override
        public Setting.ChangeRequiredAction applyChanges() {
            return Setting.ChangeRequiredAction.None;
        }

        public static class GuiItem
        extends GuiElementBase {
            private ItemStack _stack = ItemStack.field_190927_a;
            private int _colorBackground = -13421773;
            private int _colorBorder = -6250336;

            public GuiItem(int width, int height) {
                this(width, height, ItemStack.field_190927_a);
            }

            public GuiItem(int width, int height, ItemStack stack) {
                this(0, 0, width, height, stack);
            }

            public GuiItem(int x, int y, int width, int height, ItemStack stack) {
                this.setPosition(x, y);
                this.setSize(width, height);
                this.setStack(stack);
                this.setTooltip(0, Collections.emptyList());
            }

            public ItemStack getStack() {
                return this._stack;
            }

            public void setStack(ItemStack value) {
                this._stack = value;
            }

            @Override
            public List<String> getTooltip() {
                return !this.getStack().func_190926_b() ? this.getContext().getScreen().func_191927_a(this.getStack()) : Collections.emptyList();
            }

            public void setBackgroundColor(int value) {
                this._colorBackground = value;
            }

            public void resetBackgroundColor() {
                this.setBackgroundColor(-13421773);
            }

            public void setBorderColor(int value) {
                this._colorBorder = value;
            }

            public void resetBorderColor() {
                this.setBorderColor(-6250336);
            }

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                int w = this.getWidth();
                int h = this.getHeight();
                GuiItem.enableBlendAlphaStuffs();
                GuiItem.setRenderColorARGB(this._colorBackground);
                GuiItem.drawRect(1, 1, w - 2, h - 2);
                GuiItem.setRenderColorARGB(this._colorBorder);
                GuiItem.drawOutline(0, 0, w, h);
                GuiItem.disableBlendAlphaStuffs();
                ItemStack stack = this.getStack();
                if (stack.func_190926_b()) {
                    return;
                }
                GlStateManager.func_179126_j();
                GlStateManager.func_179091_B();
                RenderHelper.func_74520_c();
                GuiItem.getMC().func_175599_af().func_175042_a(stack, w / 2 - 8, h / 2 - 8);
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                GlStateManager.func_179097_i();
            }
        }

        public static class Entry
        extends BaseEntryList.Entry<BackpackRegistry.BackpackEntry> {
            private static final String HEX_DIGITS = "0123456789ABCDEF";
            private static final GuiButtonIcon.Icon ICON_COLOR_ON = new GuiButtonIcon.Icon(BaseEntry.TEXTURE_CONFIG_ICONS, 0, 16, 16, 16);
            private static final GuiButtonIcon.Icon ICON_COLOR_OFF = new GuiButtonIcon.Icon(BaseEntry.TEXTURE_CONFIG_ICONS, 16, 16, 16, 16);
            private static final GuiButtonIcon.Icon ICON_COLOR_PICK = new GuiButtonIcon.Icon(BaseEntry.TEXTURE_CONFIG_ICONS, 32, 16, 16, 16);
            public String id;
            private boolean _isDefault;
            private long _lastUpdateTime = Long.MIN_VALUE;
            private ItemStack _backpack;
            public final GuiField fieldChance;
            public final GuiItem itemBackpack;
            public final GuiField fieldBackpack;
            public final GuiField fieldLootTable;
            public final GuiButtonIcon switchColorPick;
            public final GuiButtonIcon switchColorOn;
            public final GuiLabel labelColor;
            public final GuiField fieldColorMin;
            public final GuiLabel labelColorCenter;
            public final GuiField fieldColorMax;

            public Entry(EntryListBackpack owningList) {
                super(owningList);
                int h = 18;
                this.fieldChance = new GuiField(42, h);
                this.fieldChance.setMaxLength(5);
                this.fieldChance.setCharValidator(Character::isDigit);
                this.itemBackpack = new GuiItem(h, h);
                this.fieldBackpack = new GuiField(0, h);
                this.fieldBackpack.setChangedAction(this::updateBackpackItem);
                this.fieldLootTable = new GuiField(0, h);
                this.switchColorPick = new GuiButtonIcon(h, h, ICON_COLOR_PICK);
                this.switchColorPick.setSwitch();
                this.switchColorPick.setAction(this::onColorPickPressed);
                this.switchColorOn = new GuiButtonIcon(h, h, ICON_COLOR_ON);
                this.switchColorOn.setSwitch();
                this.switchColorOn.setAction(this::onColorOnPressed);
                this.labelColor = new GuiLabel(" Min/max:");
                this.labelColor.setCenteredVertical();
                this.fieldColorMin = new GuiField(50, h);
                this.fieldColorMin.setCharValidator(c -> HEX_DIGITS.indexOf(Character.toUpperCase(c.charValue())) != -1);
                this.labelColorCenter = new GuiLabel("/");
                this.labelColorCenter.setCenteredVertical();
                this.fieldColorMax = new GuiField(50, h);
                this.fieldColorMax.setCharValidator(c -> HEX_DIGITS.indexOf(Character.toUpperCase(c.charValue())) != -1);
                this.setSpacing(2, 2, -1, 2);
                this.addFixed(this.buttonMove);
                this.addFixed(this.fieldChance);
                this.addFixed(this.itemBackpack);
                this.addWeighted(this.fieldBackpack);
                this.addWeighted(this.fieldLootTable);
                this.addFixed(this.switchColorPick);
                this.addFixed(this.buttonRemove);
                this.setValue(BackpackRegistry.BackpackEntry.DEFAULT);
            }

            @Override
            public BackpackRegistry.BackpackEntry getValue() {
                BackpackRegistry.ColorRange colorRange = this.switchColorOn.isSwitchOn() ? new BackpackRegistry.ColorRange(!this.fieldColorMin.getText().isEmpty() ? Integer.parseInt(this.fieldColorMin.getText(), 16) : 0, !this.fieldColorMax.getText().isEmpty() ? Integer.parseInt(this.fieldColorMax.getText(), 16) : 0) : null;
                return new BackpackRegistry.BackpackEntry(this.id, this.fieldBackpack.getText(), !this.fieldChance.getText().isEmpty() ? Integer.parseInt(this.fieldChance.getText()) : 0, this.fieldLootTable.getText(), colorRange, this._isDefault);
            }

            @Override
            public void setValue(BackpackRegistry.BackpackEntry value) {
                this.id = value.id;
                this._isDefault = value.isDefault;
                this.fieldChance.setText(Integer.toString(value.chance));
                this.fieldBackpack.setText(value.backpack);
                this.fieldLootTable.setText(value.lootTable);
                boolean on = value.colorRange != null;
                this.switchColorOn.setSwitch(on);
                this.switchColorOn.setIcon(on ? ICON_COLOR_ON : ICON_COLOR_OFF);
                this.fieldColorMin.setEnabled(on);
                this.fieldColorMax.setEnabled(on);
                this.fieldColorMin.setText(String.format("%06X", on ? value.colorRange.min : BackpackRegistry.ColorRange.DEFAULT.min));
                this.fieldColorMax.setText(String.format("%06X", on ? value.colorRange.max : BackpackRegistry.ColorRange.DEFAULT.max));
                Arrays.asList(this.buttonMove, this.fieldBackpack, this.fieldLootTable, this.switchColorPick, this.buttonRemove).forEach(e -> e.setEnabled(!this._isDefault));
                this.updateBackpackItem();
            }

            private void updateBackpackItem() {
                Item item = Item.func_111206_d((String)this.fieldBackpack.getText());
                ItemStack itemStack = this._backpack = item != null ? new ItemStack(item) : ItemStack.field_190927_a;
                if (this.switchColorOn.isSwitchOn()) {
                    boolean isValid = this.fieldColorMin.getText().length() == 6 && this.fieldColorMax.getText().length() == 6;
                    int minColor = isValid ? Integer.parseInt(this.fieldColorMin.getText(), 16) : 0xFF0000;
                    int maxColor = isValid ? Integer.parseInt(this.fieldColorMax.getText(), 16) : 0xFF0000;
                    BackpackRegistry.ColorRange range = new BackpackRegistry.ColorRange(minColor, maxColor);
                    int color = range.isValid() ? range.getRandom() : 0xFF0000;
                    NbtUtils.set(this._backpack, Integer.valueOf(color), "display", "color");
                }
                this.itemBackpack.setStack(this._backpack);
            }

            private void onColorPickPressed() {
                if (this.switchColorPick.isSwitchOn()) {
                    this.remove(this.fieldBackpack);
                    this.remove(this.fieldLootTable);
                    this.setSpacing(2);
                    this.insertFixed(3, this.switchColorOn);
                    this.insertFixed(4, this.labelColor);
                    this.insertWeighted(5, this.fieldColorMin);
                    this.insertFixed(6, this.labelColorCenter);
                    this.insertWeighted(7, this.fieldColorMax);
                } else {
                    this.remove(this.switchColorOn);
                    this.remove(this.labelColor);
                    this.remove(this.fieldColorMin);
                    this.remove(this.labelColorCenter);
                    this.remove(this.fieldColorMax);
                    this.setSpacing(2, 2, -1, 2);
                    this.insertWeighted(3, this.fieldBackpack);
                    this.insertWeighted(4, this.fieldLootTable);
                }
            }

            private void onColorOnPressed() {
                boolean on = this.switchColorOn.isSwitchOn();
                this.switchColorOn.setIcon(on ? ICON_COLOR_ON : ICON_COLOR_OFF);
                this.fieldColorMin.setEnabled(on);
                this.fieldColorMax.setEnabled(on);
                this.updateBackpackItem();
            }

            @Override
            public List<Status> getStatus() {
                ArrayList<Status> status = new ArrayList<Status>();
                if (this.fieldChance.getText().isEmpty()) {
                    status.add(Status.EMPTY);
                }
                if (this.fieldBackpack.getText().isEmpty()) {
                    status.add(Status.EMPTY);
                } else if (this.itemBackpack.getStack().func_190926_b()) {
                    status.add(Status.WARN());
                } else if (!(this.itemBackpack.getStack().func_77973_b() instanceof ItemBackpack)) {
                    status.add(Status.INVALID);
                } else if (this.switchColorOn.isSwitchOn() && (this.fieldColorMin.getText().length() != 6 || this.fieldColorMax.getText().length() != 6 || !new BackpackRegistry.ColorRange(Integer.parseInt(this.fieldColorMin.getText(), 16), Integer.parseInt(this.fieldColorMax.getText(), 16)).isValid())) {
                    status.add(Status.INVALID);
                }
                return status;
            }

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                long currentTime = Minecraft.func_71386_F();
                if (currentTime > this._lastUpdateTime + 1600L) {
                    this.updateBackpackItem();
                    this._lastUpdateTime = currentTime;
                }
                Entry.setTextAndBorderColorIf(this.fieldChance.getText().isEmpty(), this.fieldChance, Status.Severity.ERROR.foregroundColor);
                int backpackColor = this.fieldBackpack.getText().isEmpty() ? Status.Severity.ERROR.foregroundColor : (this.itemBackpack.getStack().func_190926_b() ? Status.Severity.WARN.foregroundColor : (!(this.itemBackpack.getStack().func_77973_b() instanceof ItemBackpack) ? Status.Severity.ERROR.foregroundColor : -1));
                Entry.setTextAndBorderColorIf(backpackColor != -1, this.fieldBackpack, backpackColor);
                if (backpackColor != -1) {
                    this.itemBackpack.setBorderColor(backpackColor);
                } else {
                    this.itemBackpack.resetBorderColor();
                }
                boolean colorOn = this.switchColorOn.isSwitchOn();
                boolean valid = !colorOn || this.fieldColorMin.getText().length() == 6 && this.fieldColorMax.getText().length() == 6 && new BackpackRegistry.ColorRange(Integer.parseInt(this.fieldColorMin.getText(), 16), Integer.parseInt(this.fieldColorMax.getText(), 16)).isValid();
                Entry.setTextAndBorderColorIf(!valid, this.fieldColorMin, Status.Severity.ERROR.foregroundColor);
                Entry.setTextAndBorderColorIf(!valid, this.fieldColorMax, Status.Severity.ERROR.foregroundColor);
                int color = !colorOn ? GuiUtils.getColorCode((char)'8', (boolean)true) : (valid ? GuiUtils.getColorCode((char)'7', (boolean)true) : Status.Severity.ERROR.foregroundColor);
                this.labelColor.setColor(color);
                this.labelColorCenter.setColor(color);
                super.draw(mouseX, mouseY, partialTicks);
            }

            private static void setTextAndBorderColorIf(boolean condition, GuiField field, int color) {
                if (condition) {
                    field.setTextColor(color);
                    field.setBorderColor(color);
                } else {
                    field.resetTextColor();
                    field.resetBorderColor();
                }
            }
        }
    }

    public static class EntryButtonRenderOptions
    extends BaseEntry
    implements IConfigValue<BackpackRegistry.RenderOptions> {
        private final Optional<BackpackRegistry.RenderOptions> _previousValue;
        private BackpackRegistry.RenderOptions _value;

        public EntryButtonRenderOptions(EntryEntityID entityID, Optional<BackpackRegistry.RenderOptions> value, Supplier<List<BackpackRegistry.BackpackEntry>> backpacks) {
            this._previousValue = value;
            this._value = value.orElse(BackpackRegistry.RenderOptions.DEFAULT);
            GuiButton button = new GuiButton(300);
            String languageKey = "config.wearablebackpacks.entity.renderOptions";
            button.setText(I18n.func_135052_a((String)languageKey, (Object[])new Object[0]));
            button.setTooltip(this.formatTooltip(languageKey, languageKey + ".tooltip", null, null));
            button.setAction(() -> EntryButtonRenderOptions.display(new ScreenRenderOptions(this, (List)backpacks.get(), entityID.entityEntry.map(e -> e.getEntityClass()).orElse(null))));
            this.setSpacing(6);
            this.addWeighted(button);
            this.addFixed(this.buttonUndo);
        }

        @Override
        public List<Status> getStatus() {
            ArrayList<Status> status = new ArrayList<Status>();
            if (!this.getValue().isPresent()) {
                status.add(Status.INVALID);
            }
            return status;
        }

        @Override
        public Optional<BackpackRegistry.RenderOptions> getValue() {
            return Optional.of(this._value);
        }

        @Override
        public void setValue(BackpackRegistry.RenderOptions value) {
            this._value = value;
        }

        @Override
        public boolean isChanged() {
            return !this._previousValue.equals(this.getValue());
        }

        @Override
        public boolean isDefault() {
            return false;
        }

        @Override
        public void undoChanges() {
            this._previousValue.ifPresent(this::setValue);
        }

        @Override
        public void setToDefault() {
        }

        @Override
        public Setting.ChangeRequiredAction applyChanges() {
            return Setting.ChangeRequiredAction.None;
        }
    }

    public static class EntryEntityID
    extends BaseEntry.Value<String> {
        private final ScreenEntityEntry _owningScreen;
        public Optional<EntityEntry> entityEntry;

        public EntryEntityID(ScreenEntityEntry owningScreen) {
            super(new EntryValueField.Text(), Optional.empty(), owningScreen._entry.map(e -> e.getValue().entityID));
            this.setLabelAndTooltip("entity.entityID");
            ((EntryValueField.Text)this.control).setChangedAction(this::onChanged);
            this._owningScreen = owningScreen;
            this.onChanged();
        }

        @Override
        public List<Status> getStatus() {
            return this.entityEntry.isPresent() ? Collections.emptyList() : (((String)this.getValue().get()).isEmpty() ? Arrays.asList(Status.EMPTY) : Arrays.asList(EntryListEntities.STATUS_NOT_FOUND));
        }

        private void onChanged() {
            String entityID = (String)this.getValue().get();
            this.entityEntry = EntryListEntities.getEntityEntry(entityID);
            this._owningScreen.setTitleLine(this._owningScreen.getTitleLineCount() - 1, EntryListEntities.getEntityEntryName(this.entityEntry, entityID));
        }
    }
}

