/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.control;

import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiButtonGlyph
extends GuiButton {
    public static final int GLYPH_SPACING = GuiButtonGlyph.getStringWidth(" ");
    public static final int DEFAULT_WIDTH = 20;
    public static final float DEFAULT_GLYPH_SCALE = 2.0f;
    private String _glyph;
    private float _glyphScale;
    private int _glyphWidth;

    public GuiButtonGlyph(String glyph) {
        this(glyph, 2.0f);
    }

    public GuiButtonGlyph(String glyph, float glyphScale) {
        this(20, glyph, glyphScale);
    }

    public GuiButtonGlyph(int width, String glyph, float glyphScale) {
        this(width, 20, glyph, glyphScale);
    }

    public GuiButtonGlyph(int width, int height, String glyph, float glyphScale) {
        this(width, height, glyph, glyphScale, "");
    }

    public GuiButtonGlyph(String glyph, String text) {
        this((int)((float)GuiButtonGlyph.getStringWidth(glyph) * 2.0f) + GLYPH_SPACING + GuiButtonGlyph.getStringWidth(text) + 20, glyph, text);
    }

    public GuiButtonGlyph(int width, String glyph, String text) {
        this(width, 20, glyph, text);
    }

    public GuiButtonGlyph(int width, int height, String glyph, String text) {
        this(width, height, glyph, 2.0f, text);
    }

    public GuiButtonGlyph(int width, String glyph, float glyphScale, String text) {
        this(width, 20, glyph, glyphScale, text);
    }

    public GuiButtonGlyph(int width, int height, String glyph, float glyphScale, String text) {
        this(0, 0, width, height, glyph, glyphScale, text);
    }

    public GuiButtonGlyph(int x, int y, int width, int height, String glyph, float glyphScale, String text) {
        super(x, y, width, height, text);
        this.setGlyph(glyph, glyphScale);
    }

    public String getGlyph() {
        return this._glyph;
    }

    public float getGlyphScale() {
        return this._glyphScale;
    }

    public int getGlyphWidth() {
        return this._glyphWidth;
    }

    public void setGlyph(String glyph) {
        this.setGlyph(glyph, this.getGlyphScale());
    }

    public void setGlyph(String glyph, float glyphScale) {
        this._glyph = glyph;
        this._glyphScale = glyphScale;
        this._glyphWidth = (int)((float)GuiButtonGlyph.getStringWidth(glyph) * glyphScale);
    }

    @Override
    protected void drawButtonForeground(boolean isHighlighted, float partialTicks) {
        String text = this.getText();
        FontRenderer fontRenderer = GuiButtonGlyph.getFontRenderer();
        int contentWidth = this.getGlyphWidth();
        if (!text.isEmpty()) {
            int maxTextWidth;
            int textWidth = fontRenderer.func_78256_a(text);
            if (textWidth > (maxTextWidth = this.getWidth() - this.getGlyphWidth() - GLYPH_SPACING - 6) && textWidth > ELLIPSIS_WIDTH) {
                text = fontRenderer.func_78269_a(text, maxTextWidth - ELLIPSIS_WIDTH).trim() + "...";
                textWidth = fontRenderer.func_78256_a(text);
            }
            contentWidth += GLYPH_SPACING + textWidth;
        }
        float scale = this.getGlyphScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_175063_a(this.getGlyph(), (float)((int)((float)((this.getWidth() - contentWidth) / 2) / scale)), (float)((int)(((float)(this.getHeight() - 8) / scale / 2.0f - 1.0f) / scale)), this.getTextColor(isHighlighted));
        GlStateManager.func_179121_F();
        if (!text.isEmpty()) {
            fontRenderer.func_175063_a(text, (float)((this.getWidth() - contentWidth) / 2 + this.getGlyphWidth() + GLYPH_SPACING), (float)((this.getHeight() - 8) / 2), this.getTextColor(isHighlighted));
        }
    }
}

