/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.client.gui.config.EntrySetting;
import net.mcft.copy.backpacks.config.Status;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Setting<T> {
    private static boolean _checkEntryValue = false;
    private final T _defaultValue;
    private T _value;
    @SideOnly(value=Side.CLIENT)
    private EntrySetting<T> _entry;
    private String _category;
    private String _name;
    private ChangeRequiredAction _changeRequiredAction = ChangeRequiredAction.None;
    private List<Supplier<Status>> _statusFuncs = new ArrayList<Supplier<Status>>();
    private boolean _doesSync = false;
    private boolean _isSynced = false;
    private T _syncedValue = null;
    private Consumer<Setting<T>> _updateAction = null;
    private String _configEntryClass = null;
    private String _comment = null;

    public Setting(T defaultValue) {
        this._defaultValue = defaultValue;
    }

    protected void init(String category, String name) {
        this._category = category;
        this._name = name;
    }

    public final Setting<T> addStatusFunc(Supplier<Status> func) {
        this._statusFuncs.add(func);
        return this;
    }

    public final Setting<T> setRequired(Setting<Boolean> setting) {
        return this.addStatusFunc(() -> (Boolean)setting.get() == false ? Status.REQUIRED(setting) : Status.NONE);
    }

    public final Setting<T> setRecommended(Setting<Boolean> setting, String key) {
        return this.addStatusFunc(() -> (Boolean)setting.get() == false ? Status.RECOMMENDED(setting, key) : Status.NONE);
    }

    public Setting<T> setRequiresWorldRejoin() {
        this._changeRequiredAction = ChangeRequiredAction.RejoinWorld;
        return this;
    }

    public Setting<T> setRequiresMinecraftRestart() {
        this._changeRequiredAction = ChangeRequiredAction.RestartMinecraft;
        return this;
    }

    public Setting<T> setSynced() {
        this._doesSync = true;
        return this;
    }

    public Setting<T> setSynced(Consumer<Setting<T>> action) {
        this.setSynced();
        return this.setUpdate(action);
    }

    public Setting<T> setUpdate(Consumer<Setting<T>> action) {
        this._updateAction = action;
        return this;
    }

    public Setting<T> setConfigEntryClass(String entryClass) {
        this._configEntryClass = entryClass;
        return this;
    }

    public Setting<T> setComment(String comment) {
        this._comment = comment;
        return this;
    }

    public String getCategory() {
        return this._category;
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._category + "." + this._name;
    }

    public T getDefault() {
        return this._defaultValue;
    }

    public T get() {
        return _checkEntryValue ? this.getEntryValue() : (this._isSynced ? this._syncedValue : this.getOwn());
    }

    public T getOwn() {
        return this._value;
    }

    public void set(T value) {
        this._value = value;
    }

    public List<Status> getStatus() {
        return this._statusFuncs.stream().map(Supplier::get).collect(Collectors.toList());
    }

    @SideOnly(value=Side.CLIENT)
    public List<Status> getStatusConfig() {
        _checkEntryValue = true;
        List<Status> list = this.getStatus();
        _checkEntryValue = false;
        return list;
    }

    public boolean isEnabled() {
        return Status.Severity.ERROR != Status.getSeverity(this.getStatus());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isEnabledConfig() {
        return Status.Severity.ERROR != Status.getSeverity(this.getStatusConfig());
    }

    public ChangeRequiredAction getChangeRequiredAction() {
        return this._changeRequiredAction;
    }

    public boolean requiresWorldRejoin() {
        return this.getChangeRequiredAction() != ChangeRequiredAction.None;
    }

    public boolean requiresMinecraftRestart() {
        return this.getChangeRequiredAction() == ChangeRequiredAction.RestartMinecraft;
    }

    public boolean doesSync() {
        return this._doesSync;
    }

    public boolean isSynced() {
        return this._isSynced;
    }

    public String getConfigEntryClass() {
        return this._configEntryClass;
    }

    public String getComment() {
        return this._comment;
    }

    private T getEntryValue() {
        return this._entry.getValue().get();
    }

    @SideOnly(value=Side.CLIENT)
    public void setEntry(EntrySetting<T> entry) {
        this._entry = entry;
    }

    @SideOnly(value=Side.CLIENT)
    public void resetEntry() {
        this._entry = null;
    }

    public void update() {
        if (this._updateAction != null) {
            this._updateAction.accept(this);
        }
    }

    protected abstract void loadFromConfiguration(Configuration var1);

    protected abstract void saveToConfiguration(Configuration var1);

    public void readSynced(NBTBase tag) {
        this._isSynced = true;
        this._syncedValue = this.read(tag);
        this.update();
    }

    public NBTBase writeSynced() {
        return this.write(this._value);
    }

    protected void resetSynced() {
        this._isSynced = false;
        this._syncedValue = null;
    }

    public abstract T read(NBTBase var1);

    public abstract NBTBase write(T var1);

    public static enum ChangeRequiredAction {
        None,
        RejoinWorld,
        RestartMinecraft;

    }
}

