/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc.util;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.INBTSerializable;

public final class NbtUtils {
    public static final String TAG_INDEX = "index";
    public static final String TAG_STACK = "stack";

    private NbtUtils() {
    }

    public static NBTBase get(ItemStack stack, String ... tags) {
        return NbtUtils.get(stack.func_77978_p(), tags);
    }

    public static NBTBase get(NBTTagCompound compound, String ... tags) {
        if (compound == null) {
            return null;
        }
        String tag = null;
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (!compound.func_74764_b(tag)) {
                return null;
            }
            if (i == tags.length - 1) break;
            compound = compound.func_74775_l(tag);
        }
        return compound.func_74781_a(tag);
    }

    public static <T> T get(ItemStack stack, T defaultValue, String ... tags) {
        return NbtUtils.get(stack.func_77978_p(), defaultValue, tags);
    }

    public static <T> T get(NBTTagCompound compound, T defaultValue, String ... tags) {
        NBTBase tag = NbtUtils.get(compound, tags);
        return tag != null ? NbtUtils.getTagValue(tag) : defaultValue;
    }

    public static boolean has(ItemStack stack, String ... tags) {
        return NbtUtils.has(stack.func_77978_p(), tags);
    }

    public static boolean has(NBTTagCompound compound, String ... tags) {
        return NbtUtils.get(compound, tags) != null;
    }

    public static void set(ItemStack stack, NBTBase nbtTag, String ... tags) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("stack is empty");
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        NbtUtils.set(compound, nbtTag, tags);
    }

    public static void set(NBTTagCompound compound, NBTBase nbtTag, String ... tags) {
        if (compound == null) {
            throw new IllegalArgumentException("compound is null");
        }
        String tag = null;
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (i == tags.length - 1) break;
            if (!compound.func_74764_b(tag)) {
                NBTTagCompound child = new NBTTagCompound();
                compound.func_74782_a(tag, (NBTBase)child);
                compound = child;
                continue;
            }
            compound = compound.func_74775_l(tag);
        }
        compound.func_74782_a(tag, nbtTag);
    }

    public static <T> void set(ItemStack stack, T value, String ... tags) {
        NbtUtils.set(stack, NbtUtils.createTag(value), tags);
    }

    public static <T> void set(NBTTagCompound compound, T value, String ... tags) {
        NbtUtils.set(compound, NbtUtils.createTag(value), tags);
    }

    public static void remove(ItemStack stack, String ... tags) {
        if (tags.length == 0) {
            throw new IllegalArgumentException("tags should have at least one element");
        }
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        NbtUtils.remove(compound, tags);
        if (compound.func_82582_d()) {
            stack.func_77982_d(null);
        }
    }

    public static void remove(NBTTagCompound compound, String ... tags) {
        if (tags.length == 0) {
            throw new IllegalArgumentException("tags should have at least one element");
        }
        if (compound == null) {
            return;
        }
        if (tags.length > 1) {
            NBTBase tag = compound.func_74781_a(tags[0]);
            if (!(tag instanceof NBTTagCompound)) {
                return;
            }
            NBTTagCompound subCompound = (NBTTagCompound)tag;
            NbtUtils.remove(subCompound, Arrays.copyOfRange(tags, 1, tags.length));
            if (!subCompound.func_82582_d()) {
                return;
            }
        }
        compound.func_82580_o(tags[0]);
    }

    public static NBTTagCompound createCompound(Object ... nameValuePairs) {
        return NbtUtils.addToCompound(new NBTTagCompound(), nameValuePairs);
    }

    public static NBTTagCompound add(ItemStack stack, Object ... nameValuePairs) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("stack is empty");
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return NbtUtils.addToCompound(stack.func_77978_p(), nameValuePairs);
    }

    public static NBTTagCompound addToCompound(NBTTagCompound compound, Object ... nameValuePairs) {
        if (compound == null) {
            throw new IllegalArgumentException("compound is null");
        }
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            String name = (String)nameValuePairs[i];
            Object value = nameValuePairs[i + 1];
            if (value == null) continue;
            compound.func_74782_a(name, NbtUtils.createTag(value));
        }
        return compound;
    }

    public static NBTTagList createList(Object ... values) {
        return NbtUtils.addToList(new NBTTagList(), values);
    }

    public static NBTTagList addToList(NBTTagList list, Object ... values) {
        if (list == null) {
            throw new IllegalArgumentException("list is null");
        }
        for (Object value : values) {
            if (value == null) continue;
            list.func_74742_a(NbtUtils.createTag(value));
        }
        return list;
    }

    public static NBTTagCompound writeItem(ItemStack item) {
        return NbtUtils.writeItem(item, true);
    }

    public static NBTTagCompound writeItem(ItemStack item, boolean writeNullAsEmptyCompound) {
        return !item.func_190926_b() ? item.func_77955_b(new NBTTagCompound()) : (writeNullAsEmptyCompound ? new NBTTagCompound() : null);
    }

    public static ItemStack readItem(NBTTagCompound compound) {
        return compound != null && !compound.func_82582_d() ? new ItemStack(compound) : ItemStack.field_190927_a;
    }

    public static NBTTagList writeItems(ItemStack[] items) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            list.func_74742_a((NBTBase)NbtUtils.createCompound(TAG_INDEX, (short)i, TAG_STACK, NbtUtils.writeItem(items[i])));
        }
        return list;
    }

    public static ItemStack[] readItems(NBTTagList list, ItemStack[] items) {
        return NbtUtils.readItems(list, items, null);
    }

    public static ItemStack[] readItems(NBTTagList list, ItemStack[] items, List<ItemStack> invalid) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            short index = compound.func_74765_d(TAG_INDEX);
            ItemStack stack = NbtUtils.readItem(compound.func_74775_l(TAG_STACK));
            if (index >= 0 || index < items.length) {
                items[index] = stack;
                continue;
            }
            if (invalid == null) continue;
            invalid.add(stack);
        }
        return items;
    }

    public static <T> T getTagValue(NBTBase tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        if (tag instanceof NBTTagByte) {
            return (T)Byte.valueOf(((NBTTagByte)tag).func_150290_f());
        }
        if (tag instanceof NBTTagShort) {
            return (T)Short.valueOf(((NBTTagShort)tag).func_150289_e());
        }
        if (tag instanceof NBTTagInt) {
            return (T)Integer.valueOf(((NBTTagInt)tag).func_150287_d());
        }
        if (tag instanceof NBTTagLong) {
            return (T)Long.valueOf(((NBTTagLong)tag).func_150291_c());
        }
        if (tag instanceof NBTTagFloat) {
            return (T)Float.valueOf(((NBTTagFloat)tag).func_150288_h());
        }
        if (tag instanceof NBTTagDouble) {
            return (T)Double.valueOf(((NBTTagDouble)tag).func_150286_g());
        }
        if (tag instanceof NBTTagString) {
            return (T)((NBTTagString)tag).func_150285_a_();
        }
        if (tag instanceof NBTTagByteArray) {
            return (T)((NBTTagByteArray)tag).func_150292_c();
        }
        if (tag instanceof NBTTagIntArray) {
            return (T)((NBTTagIntArray)tag).func_150302_c();
        }
        throw new IllegalArgumentException(NBTBase.field_82578_b[tag.func_74732_a()] + " isn't a primitive NBT tag");
    }

    public static NBTBase createTag(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (value instanceof NBTBase) {
            return (NBTBase)value;
        }
        if (value instanceof INBTSerializable) {
            return ((INBTSerializable)value).serializeNBT();
        }
        if (value instanceof Collection) {
            return (NBTBase)((Collection)value).stream().map(NbtUtils::createTag).collect(NbtUtils.toList());
        }
        if (value instanceof Byte) {
            return new NBTTagByte(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new NBTTagShort(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new NBTTagInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new NBTTagLong(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new NBTTagFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new NBTTagDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new NBTTagString((String)value);
        }
        if (value instanceof byte[]) {
            return new NBTTagByteArray((byte[])value);
        }
        if (value instanceof int[]) {
            return new NBTTagIntArray((int[])value);
        }
        throw new IllegalArgumentException("Can't create an NBT tag of value: " + value);
    }

    public static <N extends NBTBase, T extends INBTSerializable<N>> T getTagValue(N tag, T value) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        value.deserializeNBT(tag);
        return value;
    }

    public static <N extends NBTBase, T extends INBTSerializable<N>> List<T> getTagList(NBTTagList list, Supplier<T> valueSupplier) {
        return NbtUtils.stream(list).map(tag -> NbtUtils.getTagValue(tag, (INBTSerializable)valueSupplier.get())).collect(Collectors.toList());
    }

    public static <T extends NBTBase> Iterable<T> iterate(final NBTTagList list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int _index = 0;

                    @Override
                    public boolean hasNext() {
                        return this._index < list.func_74745_c();
                    }

                    @Override
                    public T next() {
                        return list.func_179238_g(this._index++);
                    }
                };
            }
        };
    }

    public static Iterable<CompoundEntry> iterate(NBTTagCompound compound) {
        return Iterables.transform((Iterable)compound.func_150296_c(), key -> new CompoundEntry((String)key, compound.func_74781_a(key)));
    }

    public static <T extends NBTBase> Stream<T> stream(NBTTagList list) {
        return StreamSupport.stream(NbtUtils.iterate(list).spliterator(), false);
    }

    public static Stream<CompoundEntry> stream(NBTTagCompound compound) {
        return StreamSupport.stream(NbtUtils.iterate(compound).spliterator(), false);
    }

    public static <T> Collector<T, NBTTagList, NBTTagList> toList() {
        return Collector.of(NBTTagList::new, (list, element) -> list.func_74742_a(NbtUtils.createTag(element)), (left, right) -> {
            for (NBTBase tag : NbtUtils.iterate(right)) {
                left.func_74742_a(tag);
            }
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, NBTTagCompound, NBTTagCompound> toCompound(Function<T, String> keyMapper, Function<T, NBTBase> tagMapper) {
        return Collector.of(NBTTagCompound::new, (compound, element) -> compound.func_74782_a((String)keyMapper.apply(element), (NBTBase)tagMapper.apply(element)), (left, right) -> {
            for (String key : right.func_150296_c()) {
                left.func_74782_a(key, right.func_74781_a(key));
            }
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static class CompoundEntry {
        public final String key;
        public final NBTBase tag;

        public CompoundEntry(String key, NBTBase tag) {
            this.key = key;
            this.tag = tag;
        }
    }

    public static final class NbtType {
        public static final int END = 0;
        public static final int BYTE = 1;
        public static final int SHORT = 2;
        public static final int INT = 3;
        public static final int LONG = 4;
        public static final int FLOAT = 5;
        public static final int DOUBLE = 6;
        public static final int BYTE_ARRAY = 7;
        public static final int STRING = 8;
        public static final int LIST = 9;
        public static final int COMPOUND = 10;
        public static final int INT_ARRAY = 11;

        private NbtType() {
        }
    }
}

