/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.network;

import io.netty.buffer.ByteBuf;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.misc.BackpackCapability;
import net.mcft.copy.backpacks.network.BackpacksMessageHandler;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageBackpackUpdate
implements IMessage {
    private int _entityId;
    private UpdateType _type;
    private ItemStack _stack = ItemStack.field_190927_a;
    private boolean _open;

    public static MessageBackpackUpdate stack(Entity entity, ItemStack stack) {
        MessageBackpackUpdate message = new MessageBackpackUpdate();
        message._entityId = entity.func_145782_y();
        message._type = UpdateType.STACK;
        message._stack = stack;
        return message;
    }

    public static MessageBackpackUpdate open(Entity entity, boolean open) {
        MessageBackpackUpdate message = new MessageBackpackUpdate();
        message._entityId = entity.func_145782_y();
        message._type = UpdateType.OPEN;
        message._open = open;
        return message;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            this._entityId = buffer.readInt();
            this._type = UpdateType.fromByte(buffer.readByte());
            switch (this._type) {
                case STACK: {
                    this._stack = buffer.func_150791_c();
                    break;
                }
                case OPEN: {
                    this._open = buffer.readBoolean();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid UpdateType");
                }
            }
        }
        catch (Exception ex) {
            this._entityId = -1;
            this._type = UpdateType.INVALID;
            this._stack = ItemStack.field_190927_a;
            this._open = false;
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.writeInt(this._entityId);
        buffer.writeByte(this._type.ordinal());
        switch (this._type) {
            case STACK: {
                buffer.func_150788_a(this._stack);
                break;
            }
            case OPEN: {
                buffer.writeBoolean(this._open);
                break;
            }
            default: {
                throw new RuntimeException("Invalid UpdateType");
            }
        }
    }

    private static enum UpdateType {
        INVALID,
        STACK,
        OPEN;


        public static UpdateType fromByte(byte b) {
            switch (b) {
                default: {
                    return INVALID;
                }
                case 1: {
                    return STACK;
                }
                case 2: 
            }
            return OPEN;
        }
    }

    public static class Handler
    extends BackpacksMessageHandler<MessageBackpackUpdate> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handle(MessageBackpackUpdate message, MessageContext ctx) {
            Entity entity = Handler.getWorld(ctx).func_73045_a(message._entityId);
            if (entity == null) {
                return;
            }
            BackpackCapability backpack = (BackpackCapability)entity.getCapability(IBackpack.CAPABILITY, null);
            if (backpack == null) {
                return;
            }
            switch (message._type) {
                case STACK: {
                    backpack.stack = message._stack;
                    break;
                }
                case OPEN: {
                    backpack.playersUsing = message._open ? 1 : 0;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid UpdateType");
                }
            }
        }
    }
}

