/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.inventory;

import biomesoplenty.core.BiomesOPlenty;
import com.google.common.base.Charsets;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.OreIngredient;
import org.apache.commons.io.FileUtils;

public class CraftingUtil {
    private static final Gson SERIALIZER = new GsonBuilder().setPrettyPrinting().create();
    public static final File RECIPES_DIR = new File(BiomesOPlenty.configDirectory, "recipes");
    public static boolean doRegistration = false;
    public static boolean generateJson = false;
    private static Map<OreIngredient, String> ingredientOreMap = Maps.newHashMap();

    public static void addShapelessRecipe(ItemStack output, Object ... inputs) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (Object input : inputs) {
            Ingredient ingredient = CraftingHelper.getIngredient((Object)input);
            if (ingredient instanceof OreIngredient) {
                ingredientOreMap.put((OreIngredient)ingredient, (String)input);
            }
            ingredients.add((Object)ingredient);
        }
        if (ingredients.isEmpty()) {
            throw new IllegalArgumentException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new IllegalArgumentException("Too many ingredients for shapeless recipe");
        }
        ShapelessRecipes recipe = new ShapelessRecipes("", output, ingredients);
        CraftingUtil.registerRecipe(CraftingUtil.unusedLocForOutput(output), (IRecipe)recipe);
    }

    public static void addShapedRecipe(ItemStack output, Object ... inputs) {
        ArrayList pattern = Lists.newArrayList();
        HashMap key = Maps.newHashMap();
        CraftingUtil.parseRecipe(pattern, key, inputs);
        int width = ((String)pattern.get(0)).length();
        int height = pattern.size();
        NonNullList ingredients = ShapedRecipes.func_192402_a((String[])pattern.toArray(new String[pattern.size()]), (Map)key, (int)width, (int)height);
        ShapedRecipes recipe = new ShapedRecipes("", width, height, ingredients, output);
        CraftingUtil.registerRecipe(CraftingUtil.unusedLocForOutput(output), (IRecipe)recipe);
    }

    public static void addRecipe(String name, IRecipe recipe) {
        ResourceLocation location = new ResourceLocation("biomesoplenty", name);
        CraftingUtil.registerRecipe(location, recipe);
    }

    private static void registerRecipe(ResourceLocation location, IRecipe recipe) {
        if (generateJson && (recipe instanceof ShapedRecipes || recipe instanceof ShapelessRecipes)) {
            String json = CraftingUtil.createJsonRecipe(recipe);
            File recipeFile = new File(RECIPES_DIR, location.func_110623_a() + ".json");
            try {
                FileUtils.writeStringToFile((File)recipeFile, (String)json, (Charset)Charsets.US_ASCII);
            }
            catch (Exception e) {
                BiomesOPlenty.logger.error("Could not write recipe to file " + recipeFile.getName());
            }
        }
        if (!doRegistration) {
            return;
        }
        if (CraftingManager.field_193380_a.func_148741_d((Object)location)) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + location);
        }
        CraftingManager.field_193380_a.func_177775_a(CraftingManager.field_193380_a.func_148742_b().size(), (Object)location, (Object)recipe);
    }

    private static void parseRecipe(List<String> pattern, Map<String, Ingredient> key, Object ... inputs) {
        Iterator<Object> itr = Arrays.asList(inputs).iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() > 3) {
                    throw new IllegalArgumentException("Invalid string length for recipe " + str.length());
                }
                if (pattern.size() <= 2) {
                    pattern.add(str);
                    continue;
                }
                throw new IllegalArgumentException("Recipe has too many crafting rows!");
            }
            if (obj instanceof Character) {
                Object next = itr.next();
                Ingredient ingredient = CraftingHelper.getIngredient((Object)next);
                if (ingredient instanceof OreIngredient) {
                    ingredientOreMap.put((OreIngredient)ingredient, (String)next);
                }
                key.put(((Character)obj).toString(), ingredient);
                continue;
            }
            throw new IllegalArgumentException("Unexpected argument of type " + obj.getClass().toString());
        }
        key.put(" ", Ingredient.field_193370_a);
    }

    private static ResourceLocation unusedLocForOutput(ItemStack output) {
        ResourceLocation baseLoc;
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation("biomesoplenty", output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation("biomesoplenty", baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    private static String createJsonRecipe(IRecipe recipe) {
        JsonObject root = new JsonObject();
        if (!recipe.func_193358_e().isEmpty()) {
            root.add("group", (JsonElement)new JsonPrimitive(recipe.func_193358_e()));
        }
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
            BiMap<String, Ingredient> keyMap = CraftingUtil.createShapedRecipeKey((NonNullList<Ingredient>)recipe.func_192400_c());
            String[] pattern = CraftingUtil.createShapedPattern(shapedRecipe, keyMap);
            String type = "minecraft:crafting_shaped";
            JsonArray patternJsonArray = new JsonArray();
            for (String row : pattern) {
                patternJsonArray.add(row);
            }
            JsonObject keyObj = new JsonObject();
            for (String key : keyMap.keySet()) {
                Ingredient ingredient = (Ingredient)keyMap.get((Object)key);
                if (ingredient instanceof OreIngredient) {
                    type = "forge:ore_shaped";
                }
                keyObj.add(key, (JsonElement)CraftingUtil.createJsonIngredient(ingredient));
            }
            root.add("type", (JsonElement)new JsonPrimitive(type));
            root.add("pattern", (JsonElement)patternJsonArray);
            root.add("key", (JsonElement)keyObj);
        } else if (recipe instanceof ShapelessRecipes) {
            String type = "minecraft:crafting_shapeless";
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (ingredient.func_193365_a().length > 1 && !(ingredient instanceof OreIngredient)) {
                    throw new IllegalArgumentException("Cannot create key for ingredient matching multiple stacks!");
                }
                if (ingredient.func_193365_a().length == 0) continue;
                if (ingredient instanceof OreIngredient) {
                    type = "forge:ore_shapeless";
                }
                ingredientsArray.add((JsonElement)CraftingUtil.createJsonIngredient(ingredient));
            }
            root.add("type", (JsonElement)new JsonPrimitive(type));
            root.add("ingredients", (JsonElement)ingredientsArray);
        }
        root.add("result", (JsonElement)CraftingUtil.createJsonItemStack(recipe.func_77571_b()));
        return SERIALIZER.toJson((JsonElement)root);
    }

    private static JsonObject createJsonIngredient(Ingredient ingredient) {
        JsonObject ret;
        if (ingredient instanceof OreIngredient) {
            ret = new JsonObject();
            ret.add("type", (JsonElement)new JsonPrimitive("forge:ore_dict"));
            ret.add("ore", (JsonElement)new JsonPrimitive(ingredientOreMap.get(ingredient)));
        } else {
            ret = CraftingUtil.createJsonItemStack(ingredient.func_193365_a()[0]);
        }
        return ret;
    }

    private static JsonObject createJsonItemStack(ItemStack stack) {
        JsonObject ret = new JsonObject();
        ret.add("item", (JsonElement)new JsonPrimitive(stack.func_77973_b().getRegistryName().toString()));
        if (stack.func_190916_E() != 1) {
            ret.add("count", (JsonElement)new JsonPrimitive((Number)stack.func_190916_E()));
        }
        if (stack.func_77960_j() != 0 || stack.func_77981_g()) {
            ret.add("data", (JsonElement)new JsonPrimitive((Number)stack.func_77960_j()));
        }
        return ret;
    }

    private static String[] createShapedPattern(ShapedRecipes recipe, BiMap<String, Ingredient> keyMap) {
        int i;
        String[] pattern = new String[recipe.field_77577_c];
        for (i = 0; i < pattern.length; ++i) {
            pattern[i] = "";
        }
        if (keyMap.isEmpty()) {
            return pattern;
        }
        for (i = 0; i < recipe.func_192400_c().size(); ++i) {
            int row;
            Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
            String key = " ";
            if (ingredient.func_193365_a().length > 1 && !(ingredient instanceof OreIngredient)) {
                throw new IllegalArgumentException("Cannot generate json for a recipe matching multiple stacks!");
            }
            if (ingredient.func_193365_a().length != 0) {
                key = (String)keyMap.inverse().get((Object)ingredient);
            }
            int n = row = i / recipe.field_77576_b;
            pattern[n] = pattern[n] + key;
        }
        return pattern;
    }

    private static BiMap<String, Ingredient> createShapedRecipeKey(NonNullList<Ingredient> ingredients) {
        HashSet ingredientsSet = Sets.newHashSet(ingredients);
        HashBiMap key = HashBiMap.create();
        int fallbackCount = 0;
        for (Ingredient ingredient : ingredientsSet) {
            if (ingredient.func_193365_a().length > 1 && !(ingredient instanceof OreIngredient)) {
                throw new IllegalArgumentException("Cannot create key for ingredient matching multiple stacks!");
            }
            if (ingredient.func_193365_a().length == 0) continue;
            if (fallbackCount == 0) {
                key.put((Object)CraftingUtil.getFallbackRecipeKey(fallbackCount), (Object)ingredient);
                ++fallbackCount;
                continue;
            }
            String letterKey = ingredient.func_193365_a()[0].func_77973_b().getRegistryName().func_110623_a().substring(0, 1).toUpperCase();
            if (!key.containsKey((Object)letterKey)) {
                key.put((Object)letterKey, (Object)ingredient);
                continue;
            }
            String fallbackKey = CraftingUtil.getFallbackRecipeKey(fallbackCount);
            if (key.containsKey((Object)fallbackKey)) {
                throw new RuntimeException("Fallback key " + fallbackKey + " is already present!");
            }
            key.put((Object)fallbackKey, (Object)ingredient);
            ++fallbackCount;
        }
        return key;
    }

    private static String getFallbackRecipeKey(int index) {
        switch (index) {
            case 1: {
                return "*";
            }
            case 2: {
                return "@";
            }
            case 3: {
                return "%";
            }
            case 4: {
                return "+";
            }
            case 5: {
                return "-";
            }
            case 6: {
                return "~";
            }
            case 7: {
                return "=";
            }
            case 8: {
                return "?";
            }
        }
        return "#";
    }

    static {
        try {
            FileUtils.deleteDirectory((File)RECIPES_DIR);
            RECIPES_DIR.mkdir();
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("Could not delete default biome config directory!");
        }
    }
}

