/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.lib.item.ItemMetadata;
import com.shinoow.acintegration.command.RitualCommand;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.thaumcraft.ACTC;
import com.shinoow.acintegration.integrations.tinkers.ACTiCon;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

@Mod(modid="acintegration", name="AbyssalCraft Integration", version="1.11.2", dependencies="required-after:forge@[14.23.5.2815,);required-after:abyssalcraft@[1.9.19,];after:tconstruct", useMetadata=false, guiFactory="com.shinoow.acintegration.client.config.ACIGuiFactory", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://raw.githubusercontent.com/Shinoow/AbyssalCraft-Integration/master/version.json", certificateFingerprint="220f10d3a93b3ff5fbaa7434cc629d863d6751b9")
public class ACIntegration {
    public static final String version = "1.11.2";
    public static final String modid = "acintegration";
    public static final String name = "AbyssalCraft Integration";
    @Mod.Metadata(value="acintegration")
    public static ModMetadata metadata;
    @Mod.Instance(value="acintegration")
    public static ACIntegration instance;
    public static Configuration cfg;
    public static boolean loadTC;
    public static boolean loadEE3;
    public static boolean tcItems;
    public static boolean loadMT;
    public static boolean loadPE;
    public static boolean tcWarpDims;
    public static boolean tcWarpMobs;
    public static boolean tcWarpPE;
    public static boolean loadTiCon;
    public static boolean loadBQ;
    public static boolean loadGS;
    public static boolean loadBW;
    public static Item dust;
    public static final CreativeTabs tabItems;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        ACIntegration.metadata.description = ACIntegration.metadata.description + "\n\n\u00a76Supporters: " + this.getSupporterList() + "\u00a7r";
        MinecraftForge.EVENT_BUS.register((Object)this);
        cfg = new Configuration(event.getSuggestedConfigurationFile());
        ACIntegration.syncConfig();
        dust = new ItemMetadata("dust", new String[]{"abyssalnite", "coralium", "dreadium"}).func_77637_a(tabItems);
        this.registerIntegrations();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        GameRegistry.addSmelting((ItemStack)new ItemStack(dust, 1, 0), (ItemStack)new ItemStack(ACItems.abyssalnite_ingot), (float)3.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(dust, 1, 1), (ItemStack)new ItemStack(ACItems.refined_coralium_ingot), (float)3.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(dust, 1, 2), (ItemStack)new ItemStack(ACItems.dreadium_ingot), (float)3.0f);
        AbyssalCraftAPI.addSingleCrystallization((ItemStack)new ItemStack(dust, 1, 0), (ItemStack)new ItemStack(ACItems.crystal_shard, 4, 12), (float)0.1f);
        AbyssalCraftAPI.addSingleCrystallization((ItemStack)new ItemStack(dust, 1, 1), (ItemStack)new ItemStack(ACItems.crystal_shard, 4, 13), (float)0.1f);
        AbyssalCraftAPI.addSingleCrystallization((ItemStack)new ItemStack(dust, 1, 2), (ItemStack)new ItemStack(ACItems.crystal_shard, 4, 14), (float)0.1f);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new RitualCommand());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        FMLLog.log((String)name, (Level)Level.WARN, (String)("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!"), (Object[])new Object[0]);
    }

    private void registerIntegrations() {
        if (ACTiCon.instance.canLoad()) {
            ACTiCon.instance.preInit();
        }
        if (ACMT.instance.canLoad()) {
            ACMT.instance.preInit();
        }
        if (ACTC.instance.canLoad()) {
            ACTC.instance.preInit();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(modid)) {
            ACIntegration.syncConfig();
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(dust.setRegistryName(new ResourceLocation(modid, "dust")));
        OreDictionary.registerOre((String)"dustAbyssalnite", (ItemStack)new ItemStack(dust, 1, 0));
        OreDictionary.registerOre((String)"dustLiquifiedCoralium", (ItemStack)new ItemStack(dust, 1, 1));
        OreDictionary.registerOre((String)"dustDreadium", (ItemStack)new ItemStack(dust, 1, 2));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        int i;
        String[] names = new String[]{"abyssalnite", "coralium", "dreadium"};
        ResourceLocation[] res = new ResourceLocation[names.length];
        for (i = 0; i < names.length; ++i) {
            res[i] = new ResourceLocation(modid, "dust_" + names[i]);
        }
        ModelBakery.registerItemVariants((Item)dust, (ResourceLocation[])res);
        for (i = 0; i < names.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)dust, (int)i, (ModelResourceLocation)new ModelResourceLocation("acintegration:dust_" + names[i], "inventory"));
        }
    }

    private static void syncConfig() {
        loadTC = cfg.get("general", "Thaumcraft Integration", true, "Whether or not to load the Thaumcraft integration. Disabling this will override any other part of said integration.").getBoolean();
        loadMT = cfg.get("general", "MineTweaker Integration", true, "Whether or not to load the MineTweaker integration.").getBoolean();
        loadPE = cfg.get("general", "ProjectE Integration", true, "Whether or not to load the ProjectE integration").getBoolean();
        tcWarpDims = cfg.get("general", "Thaumcraft Warp: Dimensions", true, "Toggles wheter or not to gain additional warp from being inside AbyssalCraft dimensions").getBoolean();
        tcWarpMobs = cfg.get("general", "Thaumcraft Warp: Mobs", true, "Toggles wheter or not to gain additional warp from attacking/being attacked by AbyssalCraft mobs").getBoolean();
        tcWarpPE = cfg.get("general", "Thaumcraft Warp: PE", true, "Toggles whether or not you gain additional warp through failing rituals and Disruptions").getBoolean();
        loadTiCon = cfg.get("general", "Tinkers' Construct", true, "Whether or not to load the Tinkers' Construct integration.").getBoolean();
        loadGS = cfg.get("general", "Game Stages", true, "Whether or not to load the Game Stages integration.").getBoolean();
        loadBW = cfg.get("general", "Bewitchment", true, "Whether or not to load the Bewitchment integration.").getBoolean();
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private String getSupporterList() {
        String names = "";
        try {
            BufferedReader nameFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Shinoow/AbyssalCraft/master/supporters.txt").openStream()));
            names = nameFile.readLine();
            nameFile.close();
        }
        catch (IOException e) {
            FMLLog.log((String)name, (Level)Level.ERROR, (String)"Failed to fetch supporter list, using local version!", (Object[])new Object[0]);
            names = "Gentlemangamer2015";
        }
        return names;
    }

    static {
        instance = new ACIntegration();
        tabItems = new CreativeTabs(modid){

            public ItemStack func_78016_d() {
                return new ItemStack(dust);
            }
        };
    }
}

