/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.io.IOException;
import java.io.InvalidClassException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.atmosphere.AtmosphereVacuum;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.util.AsteroidSmall;
import zmaster587.advancedRocketry.util.SealableBlockHandler;

public class ARConfiguration {
    public static final String configFolder = "advRocketry";
    static final byte MAGIC_CODE = -59;
    static final long MAGIC_CODE_PT2 = 0x2AAAAAAAAABL;
    static final String oreGen = "Ore Generation";
    static final String ROCKET = "Rockets";
    static final String MOD_INTERACTION = "Mod Interaction";
    static final String PLANET = "Planet";
    static final String ASTEROID = "Asteroid";
    static final String BLACK_HOLE = "Black_hole_generator";
    static final String GAS_MINING = "GasMining";
    static final String PERFORMANCE = "Performance";
    static final String CLIENT = "Client";
    public static Logger logger = LogManager.getLogger((String)"advancedrocketry");
    static String[] sealableBlockWhiteList;
    static String[] sealableBlockBlackList;
    static String[] breakableTorches;
    static String[] blackListRocketBlocksStr;
    static String[] harvestableGasses;
    static String[] entityList;
    static String[] asteriodOres;
    static String[] geodeOres;
    static String[] blackHoleGeneratorTiming;
    static String[] orbitalLaserOres;
    static String[] liquidRocketFuel;
    public Configuration config;
    private static ARConfiguration currentConfig;
    private static ARConfiguration diskConfig;
    private static boolean usingServerConfig;
    @ConfigProperty(needsSync=true)
    public int orbit = 1000;
    @ConfigProperty
    public int MoonId = -2147483647;
    @ConfigProperty(needsSync=true)
    public int spaceDimId = -2;
    @ConfigProperty
    public int fuelPointsPer10Mb = 10;
    @ConfigProperty(needsSync=true)
    public int stationSize = 1024;
    @ConfigProperty
    public double rocketThrustMultiplier;
    @ConfigProperty
    public double fuelCapacityMultiplier;
    @ConfigProperty
    public int maxBiomes = 512;
    @ConfigProperty
    public boolean rocketRequireFuel = true;
    @ConfigProperty
    public boolean enableNausea = true;
    @ConfigProperty
    public boolean enableOxygen = true;
    @ConfigProperty
    public float buildSpeedMultiplier = 1.0f;
    @ConfigProperty
    public boolean generateCopper;
    @ConfigProperty
    public int copperPerChunk;
    @ConfigProperty
    public int copperClumpSize;
    @ConfigProperty
    public boolean generateTin;
    @ConfigProperty
    public int tinPerChunk;
    @ConfigProperty
    public int tinClumpSize;
    @ConfigProperty
    public boolean generateDilithium;
    @ConfigProperty
    public int dilithiumClumpSize;
    @ConfigProperty
    public int dilithiumPerChunk;
    @ConfigProperty
    public int dilithiumPerChunkMoon;
    public int aluminumPerChunk;
    @ConfigProperty
    public int aluminumClumpSize;
    @ConfigProperty
    public boolean generateAluminum;
    @ConfigProperty
    public boolean generateIridium;
    @ConfigProperty
    public int IridiumClumpSize;
    @ConfigProperty
    public int IridiumPerChunk;
    @ConfigProperty
    public boolean generateRutile;
    @ConfigProperty
    public int rutilePerChunk;
    @ConfigProperty
    public int rutileClumpSize;
    @ConfigProperty
    public boolean allowMakingItemsForOtherMods;
    @ConfigProperty
    public boolean scrubberRequiresCartrige;
    @ConfigProperty
    public float EUMult;
    @ConfigProperty
    public float RFMult;
    @ConfigProperty
    public boolean overrideGCAir;
    @ConfigProperty
    public int fuelPointsPerDilithium;
    @ConfigProperty
    public boolean electricPlantsSpawnLightning;
    @ConfigProperty
    public boolean allowSawmillVanillaWood;
    @ConfigProperty
    public int atmosphereHandleBitMask;
    @ConfigProperty
    public boolean automaticRetroRockets;
    @ConfigProperty
    public boolean advancedVFX;
    @ConfigProperty
    public boolean enableLaserDrill;
    @ConfigProperty
    public int spaceSuitOxygenTime;
    @ConfigProperty
    public float travelTimeMultiplier;
    @ConfigProperty
    public int maxBiomesPerPlanet;
    @ConfigProperty
    public boolean enableTerraforming;
    @ConfigProperty
    public double gasCollectionMult;
    @ConfigProperty
    public boolean allowTerraforming;
    @ConfigProperty
    public int terraformingBlockSpeed;
    @ConfigProperty
    public double terraformSpeed;
    @ConfigProperty
    public boolean terraformRequiresFluid;
    @ConfigProperty
    public float microwaveRecieverMulitplier;
    @ConfigProperty
    public boolean blackListAllVanillaBiomes;
    @ConfigProperty
    public double asteroidMiningTimeMult;
    @ConfigProperty
    public boolean canPlayerRespawnInSpace;
    @ConfigProperty
    public boolean forcePlayerRespawnInSpace;
    @ConfigProperty
    public float spaceLaserPowerMult;
    @ConfigProperty
    public LinkedList<Integer> laserBlackListDims = new LinkedList();
    @ConfigProperty
    public LinkedList<String> standardLaserDrillOres = new LinkedList();
    @ConfigProperty
    public boolean laserDrillPlanet;
    @ConfigProperty
    public LinkedList<Class> bypassEntity = new LinkedList();
    @ConfigProperty
    public LinkedList<Block> torchBlocks = new LinkedList();
    @ConfigProperty
    public LinkedList<Block> blackListRocketBlocks = new LinkedList();
    @ConfigProperty
    public LinkedList<String> standardGeodeOres = new LinkedList();
    @ConfigProperty(needsSync=true, internalType=Integer.class)
    public HashSet<Integer> initiallyKnownPlanets = new HashSet();
    @ConfigProperty
    public boolean geodeOresBlackList;
    @ConfigProperty
    public boolean laserDrillOresBlackList;
    @ConfigProperty
    public boolean lockUI;
    @ConfigProperty(needsSync=true, keyType=String.class, valueType=AsteroidSmall.class)
    public HashMap<String, AsteroidSmall> asteroidTypes = new HashMap();
    @ConfigProperty
    public HashMap<String, AsteroidSmall> prevAsteroidTypes = new HashMap();
    @ConfigProperty
    public int oxygenVentSize;
    @ConfigProperty
    public int solarGeneratorMult;
    @ConfigProperty
    public boolean gravityAffectsFuel;
    @ConfigProperty
    public boolean lowGravityBoots;
    @ConfigProperty
    public float jetPackThrust;
    @ConfigProperty
    public boolean enableGravityController;
    @ConfigProperty(needsSync=true)
    public boolean planetsMustBeDiscovered;
    @ConfigProperty
    public boolean generateGeodes;
    @ConfigProperty
    public int geodeBaseSize;
    @ConfigProperty
    public int geodeVariation;
    @ConfigProperty
    public int terraformliquidRate;
    @ConfigProperty
    public boolean dropExTorches;
    @ConfigProperty
    public double oxygenVentConsumptionMult;
    @ConfigProperty
    public int terraformPlanetSpeed;
    @ConfigProperty
    public int planetDiscoveryChance;
    @ConfigProperty
    public double oxygenVentPowerMultiplier;
    @ConfigProperty
    public boolean skyOverride;
    @ConfigProperty
    public boolean planetSkyOverride;
    @ConfigProperty
    public boolean stationSkyOverride;
    @ConfigProperty
    public boolean allowTerraformNonAR;
    @ConfigProperty
    public boolean allowZeroGSpacestations;
    @ConfigProperty
    public float blackHolePowerMultiplier;
    @ConfigProperty
    public int defaultItemTimeBlackHole;
    @ConfigProperty
    public Map<ItemStack, Integer> blackHoleGeneratorBlocks = new HashMap<ItemStack, Integer>();
    @ConfigProperty
    public String[] lavaCentrifugeOutputs;
    @ConfigProperty
    public boolean generateVanillaStructures;
    @ConfigProperty
    public boolean generateCraters;
    @ConfigProperty
    public boolean generateVolcanos;
    @ConfigProperty(needsSync=true)
    public boolean experimentalSpaceFlight;

    public ARConfiguration() {
    }

    public ARConfiguration(ARConfiguration config) {
        Field[] fields = ARConfiguration.class.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
            fieldList.add(field);
        }
        fieldList.sort(new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (Field field : fieldList) {
            try {
                if (field.getClass().isAssignableFrom(List.class)) {
                    List otherList = (List)field.get(config);
                    List list = (List)otherList.getClass().newInstance();
                    list.addAll(otherList);
                    field.set(this, list);
                    continue;
                }
                if (field.getClass().isAssignableFrom(Map.class)) {
                    Map otherMap = (Map)field.get(config);
                    Map map = (Map)otherMap.getClass().newInstance();
                    for (Object key : otherMap.keySet()) {
                        Object value = otherMap.get(key);
                        map.put(key, value);
                    }
                    field.set(this, map);
                    continue;
                }
                field.set(this, field.get(config));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfigToNetwork(PacketBuffer out) {
        Field[] fields = ARConfiguration.class.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ConfigProperty.class) || !field.getAnnotation(ConfigProperty.class).needsSync()) continue;
            fieldList.add(field);
        }
        fieldList.sort(new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        try {
            for (Field field : fieldList) {
                ConfigProperty props = field.getAnnotation(ConfigProperty.class);
                int hash = field.getName().hashCode();
                out.writeInt(hash);
                try {
                    this.writeDatum(out, field.getType(), field.get(this), props);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvalidClassException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            out.writeByte(-59);
            out.writeLong(0x2AAAAAAAAABL);
        }
    }

    private void writeDatum(PacketBuffer out, Class type, Object value, ConfigProperty property) throws InvalidClassException {
        if (Integer.class.isAssignableFrom(type) || type == Integer.TYPE) {
            out.writeInt(((Integer)value).intValue());
        } else if (Float.class.isAssignableFrom(type) || type == Float.TYPE) {
            out.writeFloat(((Float)value).floatValue());
        } else if (Double.class.isAssignableFrom(type) || type == Double.TYPE) {
            out.writeDouble(((Double)value).doubleValue());
        } else if (Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE) {
            out.writeBoolean(((Boolean)value).booleanValue());
        } else if (AsteroidSmall.class.isAssignableFrom(type)) {
            AsteroidSmall asteroid = (AsteroidSmall)value;
            out.func_180714_a(asteroid.ID);
            out.writeInt(asteroid.distance);
            out.writeInt(asteroid.mass);
            out.writeInt(asteroid.minLevel);
            out.writeFloat(asteroid.massVariability);
            out.writeFloat(asteroid.richness);
            out.writeFloat(asteroid.richnessVariability);
            out.writeFloat(asteroid.probability);
            out.writeFloat(asteroid.timeMultiplier);
            out.writeInt(asteroid.stackProbabilites.size());
            for (int i = 0; i < asteroid.stackProbabilites.size(); ++i) {
                out.func_150788_a(asteroid.itemStacks.get(i));
                out.writeFloat(asteroid.stackProbabilites.get(i).floatValue());
            }
        } else if (String.class.isAssignableFrom(type)) {
            out.func_180714_a((String)value);
        } else if (List.class.isAssignableFrom(type)) {
            List list = (List)value;
            out.writeShort(list.size());
            for (Object o : list) {
                this.writeDatum(out, property.internalType(), o, property);
            }
        } else if (Set.class.isAssignableFrom(type)) {
            Set list = (Set)value;
            out.writeShort(list.size());
            for (Object o : list) {
                this.writeDatum(out, property.internalType(), o, property);
            }
        } else if (Map.class.isAssignableFrom(type)) {
            Map map = (Map)value;
            out.writeInt(map.size());
            for (Object key : map.keySet()) {
                Object mapValue = map.get(key);
                this.writeDatum(out, property.keyType(), key, property);
                this.writeDatum(out, property.valueType(), mapValue, property);
            }
        } else {
            throw new InvalidClassException("Cannot transmit class type " + type.getName());
        }
    }

    private Object readDatum(PacketBuffer in, Class type, ConfigProperty property) throws InvalidClassException, InstantiationException, IllegalAccessException {
        if (Integer.class.isAssignableFrom(type) || type == Integer.TYPE) {
            return in.readInt();
        }
        if (Float.class.isAssignableFrom(type) || type == Float.TYPE) {
            return Float.valueOf(in.readFloat());
        }
        if (Double.class.isAssignableFrom(type) || type == Double.TYPE) {
            return in.readDouble();
        }
        if (Boolean.TYPE.isAssignableFrom(type) || type == Boolean.TYPE) {
            return in.readBoolean();
        }
        if (String.class.isAssignableFrom(type)) {
            return in.func_150789_c(256);
        }
        if (AsteroidSmall.class.isAssignableFrom(type)) {
            AsteroidSmall asteroid = new AsteroidSmall();
            asteroid.ID = in.func_150789_c(128);
            asteroid.distance = in.readInt();
            asteroid.mass = in.readInt();
            asteroid.minLevel = in.readInt();
            asteroid.massVariability = in.readFloat();
            asteroid.richness = in.readFloat();
            asteroid.richnessVariability = in.readFloat();
            asteroid.probability = in.readFloat();
            asteroid.timeMultiplier = in.readFloat();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                try {
                    asteroid.itemStacks.add(in.func_150791_c());
                    asteroid.stackProbabilites.add(Float.valueOf(in.readFloat()));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return asteroid;
        }
        if (List.class.isAssignableFrom(type)) {
            List list = (List)type.newInstance();
            int listsize = in.readShort();
            for (int i = 0; i < listsize; ++i) {
                list.add(this.readDatum(in, property.internalType(), property));
            }
            return list;
        }
        if (Set.class.isAssignableFrom(type)) {
            Set set = (Set)type.newInstance();
            int listsize = in.readShort();
            for (int i = 0; i < listsize; ++i) {
                set.add(this.readDatum(in, property.internalType(), property));
            }
            return set;
        }
        if (Map.class.isAssignableFrom(type)) {
            Map map = (Map)type.newInstance();
            int mapCount = in.readInt();
            for (int i = 0; i < mapCount; ++i) {
                Object key = this.readDatum(in, property.keyType(), property);
                Object value = this.readDatum(in, property.valueType(), property);
                map.put(key, value);
            }
            return map;
        }
        throw new InvalidClassException("Cannot transmit class type " + type.getName());
    }

    public ARConfiguration readConfigFromNetwork(PacketBuffer in) {
        Field[] fields = ARConfiguration.class.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ConfigProperty.class) || !field.getAnnotation(ConfigProperty.class).needsSync()) continue;
            fieldList.add(field);
        }
        fieldList.sort(new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (Field field : fieldList) {
            ConfigProperty props = field.getAnnotation(ConfigProperty.class);
            int hash = field.getName().hashCode();
            if (hash != in.readInt()) {
                return this;
            }
            try {
                Object data = this.readDatum(in, field.getType(), props);
                field.set(this, data);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvalidClassException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        while (in.readByte() != -59 && in.readLong() == 0x2AAAAAAAAABL) {
        }
        return this;
    }

    public static ARConfiguration getCurrentConfig() {
        if (currentConfig == null) {
            logger.error("Had to generate a new config, this shouldn't happen");
            return new ARConfiguration();
        }
        return currentConfig;
    }

    public static void loadConfigFromServer(ARConfiguration config) throws Exception {
        if (usingServerConfig) {
            throw new IllegalStateException("Cannot load server config when already using server config!");
        }
        diskConfig = currentConfig;
        currentConfig = config;
        usingServerConfig = true;
    }

    public static void useClientDiskConfig() {
        if (usingServerConfig) {
            currentConfig = diskConfig;
            usingServerConfig = false;
        }
    }

    public void save() {
        if (!usingServerConfig) {
            this.config.save();
        }
    }

    public void addTorchblock(Block newblock) {
        this.torchBlocks.add(newblock);
        String[] blocks = new String[this.torchBlocks.size()];
        int index = 0;
        for (Block block : this.torchBlocks) {
            blocks[index++] = block.getRegistryName().toString();
        }
        this.config.get("general", "torchBlocks", "").set(blocks);
        this.save();
    }

    public void addSealedBlock(Block newblock) {
        SealableBlockHandler.INSTANCE.addSealableBlock(newblock);
        List<Block> blockList = SealableBlockHandler.INSTANCE.getOverridenSealableBlocks();
        String[] blocks = new String[blockList.size()];
        int index = 0;
        for (Block block : blockList) {
            blocks[index++] = block.getRegistryName().toString();
        }
        this.config.get("general", "sealableBlockWhiteList", "").set(blocks);
        this.save();
    }

    public static void loadPreInit() {
        String[] str;
        ARConfiguration arConfig = ARConfiguration.getCurrentConfig();
        Configuration config = arConfig.config;
        AtmosphereVacuum.damageValue = config.get("general", "vacuumDamage", 1, "Amount of damage taken every second in a vacuum").getInt();
        arConfig.buildSpeedMultiplier = (float)config.get("general", "buildSpeedMultiplier", 1.0, "Multiplier for the build speed of the Rocket Builder (0.5 is twice as fast 2 is half as fast").getDouble();
        arConfig.spaceDimId = config.get("general", "spaceStationId", -2, "Dimension ID to use for space stations").getInt();
        arConfig.enableNausea = config.get("general", "EnableAtmosphericNausea", true, "If true, allows players to experience nausea on non-standard atmosphere types").getBoolean();
        arConfig.enableOxygen = config.get("general", "EnableAtmosphericEffects", true, "If true, allows players being hurt due to lack of oxygen and allows effects from non-standard atmosphere types").getBoolean();
        arConfig.allowMakingItemsForOtherMods = config.get("general", "makeMaterialsForOtherMods", true, "If true the machines from AdvancedRocketry will produce things like plates/rods for other mods even if Advanced Rocketry itself does not use the material (This can increase load time)").getBoolean();
        arConfig.scrubberRequiresCartrige = config.get("general", "scrubberRequiresCartrige", true, "If true the Oxygen scrubbers require a consumable carbon collection cartridge").getBoolean();
        arConfig.enableLaserDrill = config.get("general", "EnableLaserDrill", true, "Enables the laser drill machine").getBoolean();
        arConfig.spaceLaserPowerMult = (float)config.get("general", "LaserDrillPowerMultiplier", 1.0, "Power multiplier for the laser drill machine").getDouble();
        arConfig.lowGravityBoots = config.get("general", "lowGravityBoots", false, "If true the boots only protect the player on planets with low gravity").getBoolean();
        arConfig.jetPackThrust = (float)config.get("general", "jetPackForce", 1.3, "Amount of force the jetpack provides with respect to gravity, 1 is the same acceleration as caused by Earth's gravity, 2 is 2x the acceleration caused by Earth's gravity, etc.  To make jetpack only work on low gravity planets, simply set it to a value less than 1").getDouble();
        arConfig.orbit = config.getInt("OrbitHeight", "general", 1000, 255, Integer.MAX_VALUE, "How high the rocket has to go before it reaches orbit");
        arConfig.enableTerraforming = config.get("general", "EnableTerraforming", true, "Enables terraforming items and blocks").getBoolean();
        arConfig.oxygenVentPowerMultiplier = config.get("general", "OxygenVentPowerMultiplier", 1.0, "Power consumption multiplier for the oxygen vent", 0.0, 3.4028234663852886E38).getDouble();
        arConfig.spaceSuitOxygenTime = config.get("general", "spaceSuitO2Buffer", 30, "Maximum time in minutes that the spacesuit's internal buffer can store O2 for").getInt();
        arConfig.travelTimeMultiplier = (float)config.get("general", "warpTravelTime", 1.0, "Multiplier for warp travel time").getDouble();
        arConfig.maxBiomesPerPlanet = config.get("general", "maxBiomesPerPlanet", 5, "Maximum unique biomes per planet, -1 to disable").getInt();
        arConfig.allowTerraforming = config.get("general", "allowTerraforming", false, "EXPERIMENTAL: If set to true allows contruction and usage of the terraformer.  This is known to cause strange world generation after successful terraform").getBoolean();
        arConfig.terraformingBlockSpeed = config.get("general", "biomeUpdateSpeed", 1, "How many blocks have the biome changed per tick.  Large numbers can slow the server down", Integer.MAX_VALUE, 1).getInt();
        arConfig.terraformSpeed = config.get("general", "terraformMult", 1.0, "Multplier for atmosphere change speed").getDouble();
        arConfig.terraformPlanetSpeed = config.get("general", "terraformBlockPerTick", 1, "Max number of blocks allowed to be changed per tick").getInt();
        arConfig.terraformRequiresFluid = config.get("general", "TerraformerRequiresFluids", true).getBoolean();
        arConfig.terraformliquidRate = config.get("general", "TerraformerFluidConsumeRate", 40, "how many millibuckets/t are required to keep the terraformer running").getInt();
        arConfig.allowTerraformNonAR = config.get("general", "allowTerraformingNonARWorlds", false, "If true dimensions not added by AR can be terraformed, including the overworld").getBoolean();
        liquidRocketFuel = config.get(ROCKET, "rocketFuels", new String[]{"rocketfuel"}, "List of fluid names for fluids that can be used as rocket fuel").getStringList();
        arConfig.stationSize = config.get("general", "SpaceStationBuildRadius", 1024, "The largest size a space station can be.  Should also be a power of 2 (512, 1024, 2048, 4096, ...).  CAUTION: CHANGING THIS OPTION WILL DAMAGE EXISTING STATIONS!!!").getInt();
        arConfig.canPlayerRespawnInSpace = config.get("general", "allowPlanetRespawn", false, "If true players will respawn near beds on planets IF the spawn location is in a breathable atmosphere").getBoolean();
        arConfig.forcePlayerRespawnInSpace = config.get("general", "forcePlanetRespawn", false, "If true players will respawn near beds on planets REGARDLESS of the spawn location being in a non-breathable atmosphere. Requires 'allowPlanetRespawn' being true.").getBoolean();
        arConfig.solarGeneratorMult = config.get("general", "solarGeneratorMultiplier", 1, "Amount of power per tick the solar generator should produce").getInt();
        arConfig.blackHolePowerMultiplier = config.get("general", "blackHoleGeneratorMultiplier", 1, "Multiplier for the amount of power per tick the black hole generator should produce").getInt();
        arConfig.enableGravityController = config.get("general", "enableGravityMachine", true, "If false the gravity controller cannot be built or used").getBoolean();
        arConfig.planetsMustBeDiscovered = config.get("general", "planetsMustBeDiscovered", false, "If true planets must be discovered in the warp controller before being visible").getBoolean();
        arConfig.dropExTorches = config.get("general", "dropExtinguishedTorches", false, "If true, breaking an extinguished torch will drop an extinguished torch instead of a vanilla torch").getBoolean();
        DimensionManager.dimOffset = config.getInt("minDimension", PLANET, 2, -127, 8000, "Dimensions including and after this number are allowed to be made into planets");
        arConfig.blackListAllVanillaBiomes = config.getBoolean("blackListVanillaBiomes", PLANET, false, "Prevents any vanilla biomes from spawning on planets");
        arConfig.overrideGCAir = config.get(MOD_INTERACTION, "OverrideGCAir", true, "If true Galacticcraft's air will be disabled entirely requiring use of Advanced Rocketry's Oxygen system on GC planets").getBoolean();
        arConfig.fuelPointsPerDilithium = config.get("general", "pointsPerDilithium", 500, "How many units of fuel should each Dilithium Crystal give to warp ships", 1, 1000).getInt();
        arConfig.electricPlantsSpawnLightning = config.get("general", "electricPlantsSpawnLightning", true, "Should Electric Mushrooms be able to spawn lightning").getBoolean();
        arConfig.allowSawmillVanillaWood = config.get("general", "sawMillCutVanillaWood", true, "Should the cutting machine be able to cut vanilla wood into planks").getBoolean();
        arConfig.automaticRetroRockets = config.get(ROCKET, "autoRetroRockets", true, "Setting to false will disable the retrorockets that fire automatically on reentry on both player and automated rockets").getBoolean();
        arConfig.atmosphereHandleBitMask = config.get(PERFORMANCE, "atmosphereCalculationMethod", 3, "BitMask: 0: no threading, radius based; 1: threading, radius based (EXP); 2: no threading volume based; 3: threading volume based (EXP)").getInt();
        arConfig.oxygenVentSize = config.get(PERFORMANCE, "oxygenVentSize", 32, "Radius of the O2 vent.  if atmosphereCalculationMethod is 2 or 3 then max volume is calculated from this radius.  WARNING: larger numbers can lead to lag").getInt();
        arConfig.oxygenVentConsumptionMult = config.get("general", "oxygenVentConsumptionMultiplier", 1.0, "Multiplier on how much O2 an oxygen vent consumes per tick").getDouble();
        arConfig.gravityAffectsFuel = config.get("general", "gravityAffectsFuels", true, "If true planets with higher gravity require more fuel and lower gravity would require less").getBoolean();
        arConfig.allowZeroGSpacestations = config.get("general", "allowZeroGSpacestations", false, "If true players will be able to completely disable gravity on spacestation.  It's possible to get stuck and require a teleport, you have been warned!").getBoolean();
        arConfig.experimentalSpaceFlight = config.get("general", "experimentalSpaceFlight", false, "If true, rockets will be able to actually fly around space, EXPERIMENTAL").getBoolean();
        arConfig.stationSkyOverride = config.get(CLIENT, "StationSkyOverride", true, "If true, AR will use a custom skybox on space stations").getBoolean();
        arConfig.planetSkyOverride = config.get(CLIENT, "PlanetSkyOverride", true, "If true, AR will use a custom skybox on planets").getBoolean();
        arConfig.skyOverride = config.get(CLIENT, "overworldSkyOverride", true).getBoolean();
        arConfig.advancedVFX = config.get(PERFORMANCE, "advancedVFX", true, "Advanced visual effects").getBoolean();
        arConfig.gasCollectionMult = config.get(GAS_MINING, "gasMissionMultiplier", 1.0, "Multiplier for the amount of time gas collection missions take").getDouble();
        arConfig.asteroidMiningTimeMult = config.get(ASTEROID, "miningMissionTmeMultiplier", 1.0, "Multiplier changing how long a mining mission takes").getDouble();
        asteriodOres = config.get(ASTEROID, "standardOres", new String[]{"oreIron", "oreGold", "oreCopper", "oreTin", "oreRedstone"}, "List of oredictionary names of ores allowed to spawn in asteriods").getStringList();
        geodeOres = config.get(oreGen, "geodeOres", new String[]{"oreIron", "oreGold", "oreCopper", "oreTin", "oreRedstone"}, "List of oredictionary names of ores allowed to spawn in geodes").getStringList();
        blackHoleGeneratorTiming = config.get(BLACK_HOLE, "blackHoleTimings", new String[]{"minecraft:stone;1", "minecraft:dirt;1", "minecraft:netherrack;1", "minecraft:cobblestone;1"}, "List of blocks and the amount of ticks they can power the black hole generator format: 'modname:block:meta;number_of_ticks'").getStringList();
        arConfig.defaultItemTimeBlackHole = config.get(BLACK_HOLE, "defaultBurnTime", 500, "List of blocks and the amount of ticks they can power the black hole generator format: 'modname:block:meta;number_of_ticks'").getInt();
        arConfig.geodeOresBlackList = config.get(oreGen, "geodeOres_blacklist", false, "True if the ores in geodeOres should be a blacklist, false for whitelist").getBoolean();
        arConfig.generateGeodes = config.get(oreGen, "generateGeodes", true, "If true then ore-containing geodes are generated on high pressure planets").getBoolean();
        arConfig.geodeBaseSize = config.get(oreGen, "geodeBaseSize", 36, "average size of the geodes").getInt();
        arConfig.geodeVariation = config.get(oreGen, "geodeVariation", 24, "variation in geode size").getInt();
        arConfig.generateCraters = config.get(oreGen, "generateCraters", true, "If true then low pressure planets will have meteor craters.  Note: setting this option to false overrides 'generageCraters' in the planetDefs.xml").getBoolean();
        arConfig.generateVolcanos = config.get(oreGen, "generateVolcanos", true, "If true then very hot planets planets will volcanos.  Note: setting this option to false overrides 'generateVolcanos' in the planetDefs.xml").getBoolean();
        arConfig.generateVanillaStructures = config.getBoolean("generateVanillaStructures", oreGen, false, "Enable to allow structures like villages and mineshafts to generate on planets with a breathable atmosphere.  Note, setting this to false will override 'generateStructures' in the planetDefs.xml");
        arConfig.planetDiscoveryChance = config.get(PLANET, "planetDiscoveryChance", 5, "Chance of planet discovery in the warp ship monitor is not all planets are initially discoved, chance is 1/n", 1, Integer.MAX_VALUE).getInt();
        orbitalLaserOres = config.get("general", "laserDrillOres", new String[]{"oreIron", "oreGold", "oreCopper", "oreTin", "oreRedstone", "oreDiamond"}, "List of oredictionary names of ores allowed to be mined by the laser drill if surface drilling is disabled.  Ores can be specified by just the oreName:<size> or by <modname>:<blockname>:<meta>:<size> where size is optional").getStringList();
        arConfig.laserDrillOresBlackList = config.get("general", "laserDrillOres_blacklist", false, "True if the ores in laserDrillOres should be a blacklist, false for whitelist").getBoolean();
        arConfig.laserDrillPlanet = config.get("general", "laserDrillPlanet", false, "If true the orbital laser will actually mine blocks on the planet below").getBoolean();
        boolean resetResetFromXml = config.getBoolean("ResetOnlyOnce", "general", true, "setting this to false will will prevent resetPlanetsFromXML from being set to false upon world reload.  Recommended for those who want to force ALL saves to ALWAYS use the planetDefs XML in the /config folder.  Essentially that 'Are you sure you're sure' option.  If resetPlanetsFromXML is false, this option does nothing.");
        if (resetResetFromXml) {
            config.get("general", "resetPlanetsFromXML", false).set(false);
        }
        arConfig.rocketRequireFuel = config.get(ROCKET, "rocketsRequireFuel", true, "Set to false if rockets should not require fuel to fly").getBoolean();
        arConfig.rocketThrustMultiplier = config.get(ROCKET, "thrustMultiplier", 1.0, "Multiplier for per-engine thrust").getDouble();
        arConfig.fuelCapacityMultiplier = config.get(ROCKET, "fuelCapacityMultiplier", 1.0, "Multiplier for per-tank capacity").getDouble();
        boolean masterToggle = arConfig.generateCopper = config.get(oreGen, "EnableOreGen", true).getBoolean();
        arConfig.generateCopper = config.get(oreGen, "GenerateCopper", true).getBoolean() && masterToggle;
        arConfig.copperClumpSize = config.get(oreGen, "CopperPerClump", 6).getInt();
        arConfig.copperPerChunk = config.get(oreGen, "CopperPerChunk", 10).getInt();
        arConfig.generateTin = config.get(oreGen, "GenerateTin", true).getBoolean() && masterToggle;
        arConfig.tinClumpSize = config.get(oreGen, "TinPerClump", 6).getInt();
        arConfig.tinPerChunk = config.get(oreGen, "TinPerChunk", 10).getInt();
        arConfig.generateDilithium = config.get(oreGen, "generateDilithium", true).getBoolean() && masterToggle;
        arConfig.dilithiumClumpSize = config.get(oreGen, "DilithiumPerClump", 16).getInt();
        arConfig.dilithiumPerChunk = config.get(oreGen, "DilithiumPerChunk", 1).getInt();
        arConfig.dilithiumPerChunkMoon = config.get(oreGen, "DilithiumPerChunkLuna", 10).getInt();
        arConfig.generateAluminum = config.get(oreGen, "generateAluminum", true).getBoolean() && masterToggle;
        arConfig.aluminumClumpSize = config.get(oreGen, "AluminumPerClump", 16).getInt();
        arConfig.aluminumPerChunk = config.get(oreGen, "AluminumPerChunk", 1).getInt();
        arConfig.generateIridium = config.get(oreGen, "generateIridium", false).getBoolean() && masterToggle;
        arConfig.IridiumClumpSize = config.get(oreGen, "IridiumPerClump", 16).getInt();
        arConfig.IridiumPerChunk = config.get(oreGen, "IridiumPerChunk", 1).getInt();
        arConfig.generateRutile = config.get(oreGen, "GenerateRutile", true).getBoolean() && masterToggle;
        arConfig.rutileClumpSize = config.get(oreGen, "RutilePerClump", 6).getInt();
        arConfig.rutilePerChunk = config.get(oreGen, "RutilePerChunk", 6).getInt();
        sealableBlockWhiteList = config.getStringList("sealableBlockWhiteList", "general", new String[0], "Blocks that are not automatically detected as sealable but should seal.  Format \"Mod:Blockname\"  for example \"minecraft:chest\"");
        sealableBlockBlackList = config.getStringList("sealableBlockBlackList", "general", new String[0], "Blocks that are automatically detected as sealable but should not seal.  Format \"Mod:Blockname\"  for example \"minecraft:chest\"");
        blackListRocketBlocksStr = config.getStringList("rocketBlockBlackList", "general", new String[]{"minecraft:portal", "minecraft:bedrock", "minecraft:snow_layer", "minecraft:water", "minecraft:flowing_water", "minecraft:lava", "minecraft:flowing_lava"}, "Mod:Blockname  for example \"minecraft:chest\"");
        breakableTorches = config.getStringList("torchBlocks", "general", new String[0], "Mod:Blockname  for example \"minecraft:chest\"");
        arConfig.lavaCentrifugeOutputs = config.getStringList("lavaCentrifugeOutputs", "general", new String[]{"nuggetCopper:100", "nuggetIron:100", "nuggetTin:100", "nuggetLead:100", "nuggetSilver:100", "nuggetGold:75", "nuggetDiamond:10", "nuggetUranium:10", "nuggetIridium:1"}, "Outputs and chances of objects from Enriched Lava in the Centrifuge.  Format: <oredictionaryEntry>:<weight>.  Larger weights are more frequent");
        harvestableGasses = config.getStringList("harvestableGasses", GAS_MINING, new String[0], "list of fluid names that can be harvested as Gas");
        entityList = config.getStringList("entityAtmBypass", "general", new String[0], "list entities which should not be affected by atmosphere properties");
        arConfig.microwaveRecieverMulitplier = 10.0f * (float)config.get("general", "MicrowaveRecieverMultiplier", 1.0, "Multiplier for the amount of energy produced by the microwave reciever").getDouble();
        for (String s : str = config.getStringList("spaceLaserDimIdBlackList", "general", new String[0], "Laser drill will not mine these dimension")) {
            try {
                arConfig.laserBlackListDims.add(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid number \"" + s + "\" for laser dimid blacklist");
            }
        }
    }

    public static void loadPostInit() {
        Block block;
        Fluid fluid;
        ARConfiguration arConfig = ARConfiguration.getCurrentConfig();
        logger.info("Start registering liquid rocket fuels");
        for (String str : liquidRocketFuel) {
            fluid = FluidRegistry.getFluid((String)str);
            if (fluid != null) {
                logger.info("Registering fluid " + str + " as rocket fuel");
                FuelRegistry.instance.registerFuel(FuelRegistry.FuelType.LIQUID, fluid, 1.0f);
                continue;
            }
            logger.warn("Fluid name" + str + " is not a registered fluid!");
        }
        logger.info("Finished registering liquid rocket fuels");
        liquidRocketFuel = null;
        logger.info("Start registering sealable blocks (sealableBlockWhiteList)");
        for (String str : sealableBlockWhiteList) {
            block = Block.func_149684_b((String)str);
            if (block == null) {
                logger.warn("'" + str + "' is not a valid Block");
                continue;
            }
            SealableBlockHandler.INSTANCE.addSealableBlock(block);
        }
        logger.info("End registering sealable blocks");
        sealableBlockWhiteList = null;
        logger.info("Start registering unsealable blocks (sealableBlockBlackList)");
        for (String str : sealableBlockBlackList) {
            block = Block.func_149684_b((String)str);
            if (block == null) {
                logger.warn("'" + str + "' is not a valid Block");
                continue;
            }
            SealableBlockHandler.INSTANCE.addUnsealableBlock(block);
        }
        logger.info("End registering unsealable blocks");
        sealableBlockBlackList = null;
        logger.info("Start registering torch blocks");
        for (String str : breakableTorches) {
            block = Block.func_149684_b((String)str);
            if (block == null) {
                logger.warn("'" + str + "' is not a valid Block");
                continue;
            }
            arConfig.torchBlocks.add(block);
        }
        logger.info("End registering torch blocks");
        breakableTorches = null;
        logger.info("Start registering blackhole generator blocks");
        for (String str : blackHoleGeneratorTiming) {
            String[] splitStr = str.split(";");
            String[] blockString = splitStr[0].split(":");
            Item block2 = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(blockString[0], blockString[1]));
            int metaValue = 0;
            if (blockString.length > 2) {
                try {
                    metaValue = Integer.parseInt(blockString[2]);
                }
                catch (NumberFormatException e) {
                    logger.warn("Invalid meta value location for black hole generator: " + splitStr[0] + " using " + blockString[2]);
                }
            }
            int time = 0;
            try {
                time = Integer.parseInt(splitStr[1]);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid time value for black hole generator: " + str);
            }
            if (block2 == null) {
                logger.warn("'" + splitStr[0] + "' is not a valid Block");
                continue;
            }
            arConfig.blackHoleGeneratorBlocks.put(new ItemStack(block2, 1, metaValue), time);
        }
        logger.info("End registering blackhole generator blocks");
        breakableTorches = null;
        logger.info("Start registering rocket blacklist blocks");
        for (String str : blackListRocketBlocksStr) {
            block = Block.func_149684_b((String)str);
            if (block == null) {
                logger.warn("'" + str + "' is not a valid Block");
                continue;
            }
            arConfig.blackListRocketBlocks.add(block);
        }
        logger.info("End registering rocket blacklist blocks");
        blackListRocketBlocksStr = null;
        logger.info("Start registering Harvestable Gasses");
        for (String str : harvestableGasses) {
            fluid = FluidRegistry.getFluid((String)str);
            if (fluid == null) {
                logger.warn("'" + str + "' is not a valid Fluid");
                continue;
            }
            AtmosphereRegister.getInstance().registerHarvestableFluid(fluid);
        }
        logger.info("End registering Harvestable Gasses");
        harvestableGasses = null;
        logger.info("Start registering entity atmosphere bypass");
        arConfig.bypassEntity.add(EntityArmorStand.class);
        for (String str : entityList) {
            Class<?> clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(str));
            if (clazz == null) {
                try {
                    clazz = Class.forName(str);
                    if (clazz != null && !Entity.class.isAssignableFrom(clazz)) {
                        clazz = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (clazz != null) {
                logger.info("Registering " + clazz.getName() + " for atmosphere bypass");
                arConfig.bypassEntity.add(clazz);
                continue;
            }
            logger.warn("Cannot find " + str + " while registering entity for atmosphere bypass");
        }
        entityList = null;
        logger.info("End registering entity atmosphere bypass");
        if (!arConfig.geodeOresBlackList) {
            for (String str : geodeOres) {
                arConfig.standardGeodeOres.add(str);
            }
        }
        if (!arConfig.laserDrillOresBlackList) {
            for (String str : orbitalLaserOres) {
                arConfig.standardLaserDrillOres.add(str);
            }
        }
        for (String oreName : OreDictionary.getOreNames()) {
            boolean found;
            if (arConfig.geodeOresBlackList && oreName.startsWith("ore")) {
                found = false;
                for (String str : geodeOres) {
                    if (!oreName.equals(str)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    arConfig.standardGeodeOres.add(oreName);
                }
            }
            if (!arConfig.laserDrillOresBlackList || !oreName.startsWith("ore")) continue;
            found = false;
            for (String str : orbitalLaserOres) {
                if (!oreName.equals(str)) continue;
                found = true;
                break;
            }
            if (found) continue;
            arConfig.standardLaserDrillOres.add(oreName);
        }
    }

    static {
        currentConfig = new ARConfiguration();
        usingServerConfig = false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigProperty {
        public boolean needsSync() default false;

        public Class internalType() default Object.class;

        public Class keyType() default Object.class;

        public Class valueType() default Object.class;
    }
}

