/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.inventory.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.IGalaxy;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleButtonPlanet;
import zmaster587.libVulpes.inventory.GuiModular;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleDualProgressBar;
import zmaster587.libVulpes.render.RenderHelper;

public class ModulePlanetSelector
extends ModuleContainerPan
implements IButtonInventory {
    private static final int size = 2000;
    private int topLevel;
    ISelectionNotify hostTile;
    private int currentSystem;
    private int selectedSystem;
    private double zoom;
    private boolean currentSystemChanged = false;
    private boolean stellarView;
    private List<ModuleButton> planetList;
    private ModuleContainerPan clickablePlanetList;
    private boolean allowStarSelection;
    private HashMap<Integer, PlanetRenderProperties> renderPropertiesMap;
    PlanetRenderProperties currentlySelectedPlanet;
    IPlanetDefiner planetDefiner;

    public ModulePlanetSelector(int planetId, ResourceLocation backdrop, ISelectionNotify tile, boolean star) {
        this(planetId, backdrop, tile, null, star);
    }

    public ModulePlanetSelector(int planetId, ResourceLocation backdrop, ISelectionNotify tile, IPlanetDefiner definer, boolean star) {
        super(0, 0, null, null, backdrop, 0, 0, 0, 0, 2000, 2000);
        this.planetDefiner = definer;
        this.hostTile = tile;
        int center = 1000;
        this.zoom = 1.0;
        this.planetList = new ArrayList<ModuleButton>();
        this.moduleList = new ArrayList();
        this.staticModuleList = new ArrayList();
        this.renderPropertiesMap = new HashMap();
        this.currentlySelectedPlanet = new PlanetRenderProperties();
        this.currentSystem = 10000;
        this.selectedSystem = -2147483647;
        this.stellarView = false;
        this.staticModuleList.add(new ModuleButton(0, 0, -2147483647, "<< Up", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        this.staticModuleList.add(new ModuleButton(0, 18, -2147483646, "Select", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        this.staticModuleList.add(new ModuleButton(0, 36, -2147483645, "PlanetList", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        ModuleDualProgressBar progressBar = new ModuleDualProgressBar(100, 0, 0, TextureResources.atmIndicator, (IProgressBar)tile, "%b -> %a Earth's atmospheric pressure");
        this.staticModuleList.add(progressBar);
        progressBar.setTooltipValueMultiplier(0.16f);
        progressBar = new ModuleDualProgressBar(200, 0, 2, TextureResources.massIndicator, (IProgressBar)tile, "%b -> %a Earth's mass");
        this.staticModuleList.add(progressBar);
        progressBar.setTooltipValueMultiplier(0.02f);
        progressBar = new ModuleDualProgressBar(300, 0, 1, TextureResources.distanceIndicator, (IProgressBar)tile, "%b -> %a Relative Distance units");
        this.staticModuleList.add(progressBar);
        progressBar.setTooltipValueMultiplier(0.16f);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            if (star) {
                this.topLevel = -2147483647;
                this.currentSystem = 10000 + planetId;
                this.renderStarSystem(DimensionManager.getInstance().getStar(planetId), center, center, 1.0f, 0.5f);
            } else {
                this.currentSystem = planetId;
                this.topLevel = planetId;
                this.renderPlanetarySystem(DimensionManager.getInstance().getDimensionProperties(planetId), center, center, 1.0f, 3.0f);
            }
            this.refreshSideBar(true, this.currentSystem);
        }
    }

    public void onScroll(int dwheel) {
        if (this.clickablePlanetList != null) {
            this.clickablePlanetList.onScroll(dwheel);
        }
    }

    public void setAllowStarSelection(boolean allow) {
        this.allowStarSelection = allow;
    }

    public int getSelectedSystem() {
        return this.selectedSystem;
    }

    public void setSelectedSystem(int id) {
        this.selectedSystem = id;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderGalaxyMap(IGalaxy galaxy, int posX, int posY, float distanceZoomMultiplier, float planetSizeMultiplier) {
        Collection<StellarBody> stars = galaxy.getStars();
        for (StellarBody star : stars) {
            ModuleButton button;
            if (this.planetDefiner != null && !this.planetDefiner.isStarKnown(star)) continue;
            int displaySize = (int)(planetSizeMultiplier * (float)star.getDisplayRadius());
            int offsetX = star.getPosX() + posX - displaySize / 2;
            int offsetY = star.getPosZ() + posY - displaySize / 2;
            if (star.getSubStars() != null && !star.getSubStars().isEmpty()) {
                float phaseInc = 360 / star.getSubStars().size();
                float phase = 0.0f;
                for (StellarBody star2 : star.getSubStars()) {
                    displaySize = (int)(planetSizeMultiplier * (float)star2.getDisplayRadius());
                    int deltaX = (int)((double)(star2.getStarSeparation() * MathHelper.func_76134_b((float)phase)) * 0.5);
                    int deltaY = (int)((double)(star2.getStarSeparation() * MathHelper.func_76126_a((float)phase)) * 0.5);
                    button = new ModuleButton(offsetX + deltaX, offsetY + deltaY, star.getId() + 10000, "", (IButtonInventory)this, new ResourceLocation[]{star.isBlackHole() ? TextureResources.locationBlackHole_icon : TextureResources.locationSunNew}, String.format("Name: %s\nNumber of Planets: %d", star.getName(), star.getNumPlanets()), displaySize, displaySize);
                    this.planetList.add(button);
                    button.setSound("buttonBlipA");
                    button.setBGColor(star2.getColorRGB8());
                    phase += phaseInc;
                }
            }
            button = new ModuleButton(offsetX, offsetY, star.getId() + 10000, "", (IButtonInventory)this, new ResourceLocation[]{star.isBlackHole() ? TextureResources.locationBlackHole_icon : TextureResources.locationSunNew}, String.format("Name: %s\nNumber of Planets: %d", star.getName(), star.getNumPlanets()), displaySize, displaySize);
            this.planetList.add(button);
            button.setSound("buttonBlipA");
            button.setBGColor(star.getColorRGB8());
            this.renderPropertiesMap.put(star.getId() + 10000, new PlanetRenderProperties(displaySize, offsetX, offsetY));
        }
        this.moduleList.addAll(this.planetList);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderStarSystem(StellarBody star, int posX, int posY, float distanceZoomMultiplier, float planetSizeMultiplier) {
        ModuleButton button;
        int displaySize = (int)(planetSizeMultiplier * (float)star.getDisplayRadius());
        int offsetX = posX - displaySize / 2;
        int offsetY = posY - displaySize / 2;
        if (star.getSubStars() != null && !star.getSubStars().isEmpty()) {
            float phaseInc = 360 / star.getSubStars().size();
            float phase = 0.0f;
            for (StellarBody star2 : star.getSubStars()) {
                displaySize = (int)(planetSizeMultiplier * (float)star2.getDisplayRadius());
                int deltaX = (int)((double)(star2.getStarSeparation() * MathHelper.func_76134_b((float)phase)) * 0.5);
                int deltaY = (int)((double)(star2.getStarSeparation() * MathHelper.func_76126_a((float)phase)) * 0.5);
                button = new ModuleButton(offsetX + deltaX, offsetY + deltaY, star.getId() + 10000, "", (IButtonInventory)this, new ResourceLocation[]{star.isBlackHole() ? TextureResources.locationBlackHole_icon : TextureResources.locationSunNew}, String.format("Name: %s\nNumber of Planets: %d", star.getName(), star.getNumPlanets()), displaySize, displaySize);
                this.planetList.add(button);
                button.setSound("buttonBlipA");
                button.setBGColor(star2.getColorRGB8());
                phase += phaseInc;
            }
        }
        displaySize = (int)(planetSizeMultiplier * (float)star.getDisplayRadius());
        offsetX = posX - displaySize / 2;
        offsetY = posY - displaySize / 2;
        button = new ModuleButton(offsetX, offsetY, star.getId() + 10000, "", (IButtonInventory)this, new ResourceLocation[]{star.isBlackHole() ? TextureResources.locationBlackHole_icon : TextureResources.locationSunNew}, String.format("Name: %s\nNumber of Planets: %d", star.getName(), star.getNumPlanets()), displaySize, displaySize);
        this.planetList.add(button);
        button.setSound("buttonBlipA");
        button.setBGColor(star.getColorRGB8());
        this.renderPropertiesMap.put(star.getId() + 10000, new PlanetRenderProperties(displaySize, offsetX, offsetY));
        displaySize = (int)(planetSizeMultiplier * 100.0f);
        offsetX = posX - displaySize / 2;
        offsetY = posY - displaySize / 2;
        for (IDimensionProperties properties : star.getPlanets()) {
            if (this.planetDefiner != null && !this.planetDefiner.isPlanetKnown(properties) || properties.isMoon()) continue;
            this.renderPlanets((DimensionProperties)properties, offsetX + displaySize / 2, offsetY + displaySize / 2, displaySize, distanceZoomMultiplier, planetSizeMultiplier);
        }
        this.moduleList.addAll(this.planetList);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPlanetarySystem(DimensionProperties planet, int posX, int posY, float distanceZoomMultiplier, float planetSizeMultiplier) {
        int displaySize = Math.max((int)(planetSizeMultiplier * planet.gravitationalMultiplier / 0.02f), 7);
        int offsetX = (int)(distanceZoomMultiplier * (float)posX) - displaySize / 2;
        int offsetY = (int)(distanceZoomMultiplier * (float)posY) - displaySize / 2;
        displaySize = (int)((float)displaySize * distanceZoomMultiplier);
        ModuleButtonPlanet button = new ModuleButtonPlanet(offsetX, offsetY, planet.getId(), "", this, planet, planet.getName(), displaySize, displaySize);
        this.planetList.add(button);
        button.setSound("buttonBlipA");
        this.renderPropertiesMap.put(planet.getId(), new PlanetRenderProperties(displaySize, offsetX, offsetY));
        for (Integer childId : planet.getChildPlanets()) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(childId);
            if (this.planetDefiner != null && !this.planetDefiner.isPlanetKnown(properties)) continue;
            this.renderPlanets(properties, offsetX + displaySize / 2, offsetY + displaySize / 2, displaySize, distanceZoomMultiplier, planetSizeMultiplier);
        }
        this.moduleList.addAll(this.planetList);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPlanets(DimensionProperties planet, int parentOffsetX, int parentOffsetY, int parentRadius, float distanceMultiplier, float planetSizeMultiplier) {
        int displaySize = Math.max((int)(planetSizeMultiplier * planet.gravitationalMultiplier / 0.02f), 7);
        int offsetX = parentOffsetX + (int)(Math.cos(planet.orbitTheta) * (double)((float)planet.orbitalDist * distanceMultiplier + (float)parentRadius)) - displaySize / 2;
        int offsetY = parentOffsetY + (int)(Math.sin(planet.orbitTheta) * (double)((float)planet.orbitalDist * distanceMultiplier + (float)parentRadius)) - displaySize / 2;
        ModuleButtonPlanet button = new ModuleButtonPlanet(offsetX, offsetY, planet.getId(), "", this, planet, planet.getName() + "\nMoons: " + planet.getChildPlanets().size(), displaySize, displaySize);
        this.planetList.add(button);
        button.setSound("buttonBlipA");
        this.renderPropertiesMap.put(planet.getId(), new PlanetRenderProperties(displaySize, offsetX, offsetY));
    }

    @SideOnly(value=Side.CLIENT)
    public void setPlanetAsKnown(int id) {
        for (ModuleBase module : this.moduleList) {
            if (!(module instanceof ModuleButton) || ((ModuleButton)module).buttonId != id) continue;
            ((ModuleButton)module).setImage(new ResourceLocation[]{DimensionManager.getInstance().getDimensionProperties(id).getPlanetIcon()});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<GuiButton> addButtons(int x, int y) {
        this.screenSizeX = Minecraft.func_71410_x().field_71443_c;
        this.screenSizeY = Minecraft.func_71410_x().field_71440_d;
        this.setOffset2(this.internalOffsetX - Minecraft.func_71410_x().field_71443_c / 4, this.internalOffsetY - Minecraft.func_71410_x().field_71440_d / 4);
        List list = super.addButtons(x, y);
        if (this.clickablePlanetList != null) {
            list.addAll(this.clickablePlanetList.addButtons(x, y));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    private void redrawSystem() {
        int offsetX = -this.currentPosX;
        int offsetY = -this.currentPosY;
        this.setOffset2(0, 0);
        for (int i = 0; i < this.planetList.size(); ++i) {
            ModuleBase module = (ModuleBase)this.planetList.get(i);
            if (!this.planetList.contains(module)) continue;
            this.buttonList.remove(((ModuleButton)module).button);
        }
        this.moduleList.removeAll(this.planetList);
        this.planetList.clear();
        if (!this.stellarView) {
            if (this.currentSystem < 10000) {
                DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.currentSystem);
                this.renderPlanetarySystem(properties, 1000, 1000, 1.0f, 3.0f * (float)properties.getPathLengthToStar());
            } else {
                this.renderStarSystem(DimensionManager.getInstance().getStar(this.currentSystem - 10000), 1000, 1000, 1.0f * (float)this.zoom, (float)this.zoom * 0.5f);
            }
        } else {
            this.renderGalaxyMap(DimensionManager.getInstance(), 1000, 1000, 1.0f * (float)this.zoom, (float)this.zoom * 0.25f);
        }
        int x = this.currentPosX - 1000;
        int y = this.currentPosY - 1000;
        this.screenSizeX = Minecraft.func_71410_x().field_71443_c;
        this.screenSizeY = Minecraft.func_71410_x().field_71440_d;
        for (ModuleBase moduleBase : this.planetList) {
            for (GuiButton module2 : moduleBase.addButtons(this.currentPosX, this.currentPosY)) {
                if (module2.field_146128_h <= 128 + offsetX && this.clickablePlanetList != null && this.clickablePlanetList.isEnabled()) continue;
                this.buttonList.add(module2);
            }
        }
        this.setOffset2(offsetX, offsetY);
    }

    @SideOnly(value=Side.CLIENT)
    public void onMouseClicked(GuiModular gui, int x, int y, int button) {
        if (this.clickablePlanetList != null) {
            this.clickablePlanetList.onMouseClicked(gui, x, y, button);
        }
        super.onMouseClicked(gui, x, y, button);
        if (this.currentSystemChanged) {
            this.currentPosX = 0;
            this.currentPosY = 0;
            this.zoom = 1.0;
            this.redrawSystem();
            this.setOffset2(this.internalOffsetX - Minecraft.func_71410_x().field_71443_c / 4, this.internalOffsetY - Minecraft.func_71410_x().field_71440_d / 4);
            this.currentSystemChanged = false;
            this.hostTile.onSystemFocusChanged((Object)this);
            this.refreshSideBar(true, this.selectedSystem);
        }
    }

    public void renderForeground(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
        super.renderForeground(guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
    }

    protected void moveContainerInterior(int deltaX, int deltaY) {
        super.moveContainerInterior(deltaX, deltaY);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        if (!this.stellarView && Minecraft.func_71386_F() % 5L == 0L) {
            this.redrawSystem();
        }
        super.renderBackground(gui, x, y, mouseX, mouseY, font);
        int center = 1000;
        int numSegments = 50;
        float theta = (float)(Math.PI * 2 / (double)numSegments);
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        GL11.glPushMatrix();
        if (!this.stellarView) {
            for (int ii = 1; ii < 10; ++ii) {
                int radius = ii * 80;
                float x2 = radius;
                float y2 = 0.0f;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(center + this.currentPosX), (float)(center + this.currentPosY), (float)0.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GL11.glColor4f((float)0.8f, (float)0.8f, (float)1.0f, (float)0.2f);
                GL11.glEnable((int)2852);
                GL11.glLineStipple((int)5, (short)21845);
                buffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                for (int i = 0; i < numSegments; ++i) {
                    buffer.func_181662_b((double)x2, (double)y2, 200.0).func_181675_d();
                    float t = x2;
                    x2 = cos * x2 - sin * y2;
                    y2 = sin * t + cos * y2;
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
                GL11.glLineStipple((int)5, (short)-1);
            }
        }
        if (this.selectedSystem != -2147483647) {
            gui.field_146297_k.func_110434_K().func_110577_a(TextureResources.selectionCircle);
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            float radius = this.currentlySelectedPlanet.radius / 2;
            if (this.renderPropertiesMap.containsKey(this.selectedSystem)) {
                PlanetRenderProperties base = this.renderPropertiesMap.get(this.selectedSystem);
                GL11.glTranslatef((float)(base.posX + this.currentPosX + base.radius / 2), (float)(base.posY + this.currentPosY + base.radius / 2), (float)0.0f);
            } else {
                GL11.glTranslatef((float)((float)(this.currentlySelectedPlanet.posX + this.currentPosX) + radius), (float)((float)(this.currentlySelectedPlanet.posY + this.currentPosY) + radius), (float)0.0f);
            }
            double progress = (float)(System.currentTimeMillis() % 20000L) / 50.0f;
            GL11.glPushMatrix();
            GL11.glRotated((double)progress, (double)0.0, (double)0.0, (double)1.0);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUVNoNormal((BufferBuilder)buffer, (double)1.0, (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            radius = (float)((double)radius * (1.2 + 0.1 * Math.sin(progress / 10.0)));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUVNoNormal((BufferBuilder)buffer, (double)1.0, (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == -2147483647) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.currentSystem);
            if (this.topLevel == -2147483647 || this.currentSystem != this.topLevel) {
                if (this.currentSystem < 10000 && properties.isMoon()) {
                    this.currentSystem = properties.getParentPlanet();
                } else {
                    if (this.currentSystem >= 10000) {
                        this.stellarView = true;
                    }
                    this.currentSystem = properties.getStar().getId() + 10000;
                }
                this.currentSystemChanged = true;
                this.selectedSystem = -2147483647;
            }
        } else if (buttonId == -2147483646) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.selectedSystem);
            if (this.selectedSystem < 10000 || this.allowStarSelection && properties.getStar().isBlackHole()) {
                this.hostTile.onSelectionConfirmed((Object)this);
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
            }
        } else if (buttonId == -2147483645) {
            if (this.clickablePlanetList != null) {
                boolean flag = !this.clickablePlanetList.isEnabled();
                this.clickablePlanetList.setEnabled(flag);
            }
        } else if (this.selectedSystem == buttonId) {
            this.currentSystem = buttonId;
            this.currentSystemChanged = true;
            this.stellarView = false;
        } else {
            this.selectedSystem = buttonId;
            this.currentlySelectedPlanet = this.renderPropertiesMap.get(buttonId);
            this.hostTile.onSelected((Object)this);
            this.refreshSideBar(this.currentSystemChanged, this.selectedSystem);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void refreshSideBar(boolean planetChanged, int selectedPlanet) {
        LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
        if (!this.stellarView) {
            if (this.currentSystem < 10000) {
                DimensionProperties parent = DimensionManager.getInstance().getDimensionProperties(this.currentSystem);
                Iterator<IDimensionProperties> propertyList = new LinkedList<Integer>(parent.getChildPlanets());
                propertyList.add((IDimensionProperties)((Object)Integer.valueOf(parent.getId())));
                int i = 0;
                Iterator iterator = propertyList.iterator();
                while (iterator.hasNext()) {
                    int childId = (Integer)iterator.next();
                    DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(childId);
                    if (this.planetDefiner != null && !this.planetDefiner.isPlanetKnown(properties)) continue;
                    ModuleButton button = new ModuleButton(0, i * 18, properties.getId(), properties.getName(), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
                    list2.add(button);
                    if (properties.getId() == selectedPlanet) {
                        button.setColor(-56798);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                for (IDimensionProperties properties : DimensionManager.getInstance().getStar(this.currentSystem - 10000).getPlanets()) {
                    if (this.planetDefiner != null && !this.planetDefiner.isPlanetKnown(properties)) continue;
                    if (!properties.isMoon() && properties.getId() != ARConfiguration.getCurrentConfig().spaceDimId) {
                        ModuleButton button = new ModuleButton(0, i * 18, properties.getId(), properties.getName(), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
                        list2.add(button);
                        if (properties.getId() == selectedPlanet) {
                            button.setColor(-56798);
                        }
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            for (StellarBody properties : DimensionManager.getInstance().getStars()) {
                if (this.planetDefiner != null && !this.planetDefiner.isStarKnown(properties)) continue;
                ModuleButton button = new ModuleButton(0, i * 18, properties.getId() + 10000, properties.getName(), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
                list2.add(button);
                if (properties.getId() + 10000 == selectedPlanet) {
                    button.setColor(-56798);
                }
                ++i;
            }
        }
        boolean enabled = this.clickablePlanetList != null && this.clickablePlanetList.isEnabled();
        int offX = 0;
        int offY = 0;
        if (this.clickablePlanetList != null) {
            this.staticModuleList.remove(this.clickablePlanetList);
            offX = this.clickablePlanetList.getScrollX();
            offY = this.clickablePlanetList.getScrollY();
        }
        this.clickablePlanetList = new ModuleContainerPan(0, 128, list2, new LinkedList(), null, 512, 256, 0, 0, 258, 8192);
        this.staticModuleList.add(this.clickablePlanetList);
        this.clickablePlanetList.addButtons(0, 0);
        if (!planetChanged) {
            this.clickablePlanetList.setOffset2(-offX, -offY);
        } else {
            this.clickablePlanetList.setOffset2(0, 64);
        }
        this.clickablePlanetList.setEnabled(enabled);
    }

    public boolean needsUpdate(int localId) {
        for (ModuleBase module : this.staticModuleList) {
            if (localId >= 0 && localId < module.numberOfChangesToSend()) {
                return module.needsUpdate(localId);
            }
            localId -= module.numberOfChangesToSend();
        }
        return false;
    }

    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        for (ModuleBase module : this.staticModuleList) {
            if (localId >= 0 && localId < module.numberOfChangesToSend()) {
                module.sendChanges(container, crafter, variableId, localId);
                return;
            }
            localId -= module.numberOfChangesToSend();
        }
    }

    public void onChangeRecieved(int slot, int value) {
        for (ModuleBase module : this.staticModuleList) {
            if (slot >= 0 && slot < module.numberOfChangesToSend()) {
                module.onChangeRecieved(slot, value);
                return;
            }
            slot -= module.numberOfChangesToSend();
        }
    }

    public int numberOfChangesToSend() {
        int numChanges = 0;
        for (ModuleBase module : this.staticModuleList) {
            numChanges += module.numberOfChangesToSend();
        }
        return numChanges;
    }

    private class PlanetRenderProperties {
        int radius;
        int posX;
        int posY;

        public PlanetRenderProperties() {
        }

        public PlanetRenderProperties(int radius, int posX, int posY) {
            this.radius = radius;
            this.posX = posX;
            this.posY = posY;
        }
    }
}

