/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.asm.mixin.core.client;

import net.malisis.core.block.IComponent;
import net.malisis.core.registry.Registries;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.callback.CallbackResult;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

public class MixinMalisisRenderer {

    @Mixin(value={BlockModelShapes.class})
    public static abstract class MixinBlockModelShapes {
        @Inject(method={"getTexture"}, at={@At(value="HEAD")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
        private void onGetTexture(IBlockState state, CallbackInfoReturnable<TextureAtlasSprite> cir) {
            if (IComponent.getComponent(IIconProvider.class, state.func_177230_c()) != null) {
                cir.setReturnValue(Registries.getParticleIcon(state));
            }
        }
    }

    @Mixin(value={RenderItem.class})
    public static abstract class MixinRenderItem {
        @Inject(method={"renderModel(Lnet/minecraft/client/renderer/block/model/IBakedModel;ILnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
        private void onRenderModel(IBakedModel model, int color, ItemStack itemStack, CallbackInfo ci) {
            if (Registries.renderItem(itemStack)) {
                ci.cancel();
            }
        }
    }

    @Mixin(value={BlockRendererDispatcher.class})
    public static abstract class MixinBlockRendererDispatcher {
        @Inject(method={"renderBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/state/IBlockState;getRenderType()Lnet/minecraft/util/EnumBlockRenderType;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
        private void onRenderBlock(IBlockState state, BlockPos pos, IBlockAccess world, BufferBuilder buffer, CallbackInfoReturnable<Boolean> cir) {
            CallbackResult<Boolean> cb = Registries.processRenderBlockCallbacks(buffer, world, pos, state);
            if (cb.shouldReturn()) {
                cir.setReturnValue(cb.getValue());
            }
        }
    }
}

