/*
 * Decompiled with CFR 0.152.
 */
package com.xenomustache.ironfurnaces.blocks;

import com.xenomustache.ironfurnaces.IronFurnaces;
import com.xenomustache.ironfurnaces.tileentity.TileEntityShulkerFurnace;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShulkerFurnace
extends BlockContainer {
    public static final PropertyEnum<EnumFacing> FACING = PropertyDirection.func_177714_a((String)"facing");
    protected String name;
    protected static boolean isBurning;
    protected final EnumDyeColor color;

    public BlockShulkerFurnace(String name, boolean isBurning, EnumDyeColor colorIn) {
        super(Material.field_151576_e, MapColor.field_151660_b);
        this.name = name;
        BlockShulkerFurnace.isBurning = isBurning;
        this.color = colorIn;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.setCreativeTab(IronFurnaces.creativeTab);
    }

    public void registerItemModel(Item itemBlock) {
        IronFurnaces.proxy.registerItemRenderer(itemBlock, 0, this.name);
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public BlockShulkerFurnace setCreativeTab(CreativeTabs tab) {
        if (!isBurning) {
            super.func_149647_a(tab);
        } else if (isBurning) {
            super.func_149647_a(null);
        }
        return this;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b(FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a(FACING, (Comparable)enumfacing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (isBurning) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b(FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityShulkerFurnace(this.color);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (playerIn.func_175149_v()) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityShulkerFurnace) {
            AxisAlignedBB axisalignedbb;
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b(FACING);
            boolean flag = ((TileEntityShulkerFurnace)tileentity).getAnimationStatus() == TileEntityShulkerFurnace.AnimationStatus.CLOSED ? !worldIn.func_184143_b((axisalignedbb = field_185505_j.func_72321_a((double)(0.5f * (float)enumfacing.func_82601_c()), (double)(0.5f * (float)enumfacing.func_96559_d()), (double)(0.5f * (float)enumfacing.func_82599_e())).func_191195_a((double)enumfacing.func_82601_c(), (double)enumfacing.func_96559_d(), (double)enumfacing.func_82599_e())).func_186670_a(pos.func_177972_a(enumfacing))) : true;
            if (flag) {
                playerIn.func_71029_a(StatList.field_191272_ae);
                playerIn.func_71007_a((IInventory)tileentity);
            }
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)facing);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a(FACING, (Comparable)enumfacing);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityShulkerFurnace) {
            TileEntityShulkerFurnace tileentityshulkerfurnace = (TileEntityShulkerFurnace)worldIn.func_175625_s(pos);
            tileentityshulkerfurnace.setDestroyedByCreativePlayer(player.field_71075_bZ.field_75098_d);
            tileentityshulkerfurnace.func_184281_d(player);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityShulkerFurnace) {
            ((TileEntityShulkerFurnace)tileentity).func_190575_a(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityShulkerFurnace) {
            TileEntityShulkerFurnace tileentityshulkerfurnace = (TileEntityShulkerFurnace)tileentity;
            if (!tileentityshulkerfurnace.isCleared() && tileentityshulkerfurnace.shouldDrop()) {
                ItemStack itemstack = new ItemStack(Item.func_150898_a((Block)this));
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound.func_74782_a("BlockEntityTag", (NBTBase)((TileEntityShulkerFurnace)tileentity).saveToNbt(nbttagcompound1));
                itemstack.func_77982_d(nbttagcompound);
                if (tileentityshulkerfurnace.func_145818_k_()) {
                    itemstack.func_151001_c(tileentityshulkerfurnace.func_70005_c_());
                    tileentityshulkerfurnace.func_190575_a("");
                }
                BlockShulkerFurnace.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
            }
            worldIn.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("BlockEntityTag", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("BlockEntityTag");
            if (nbttagcompound1.func_150297_b("LootTable", 8)) {
                tooltip.add("???????");
            }
            if (nbttagcompound1.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    tooltip.add(String.format("%s x%d", itemstack.func_82833_r(), itemstack.func_190916_E()));
                }
                if (j - i > 0) {
                    tooltip.add(String.format(TextFormatting.ITALIC + I18n.func_74838_a((String)"container.shulkerFurnace.more"), j - i));
                }
            }
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tileentity = source.func_175625_s(pos);
        return tileentity instanceof TileEntityShulkerFurnace ? ((TileEntityShulkerFurnace)tileentity).getBoundingBox(state) : field_185505_j;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack itemstack = super.func_185473_a(worldIn, pos, state);
        TileEntityShulkerFurnace tileentityshulkerfurnace = (TileEntityShulkerFurnace)worldIn.func_175625_s(pos);
        NBTTagCompound nbttagcompound = tileentityshulkerfurnace.saveToNbt(new NBTTagCompound());
        if (!nbttagcompound.func_82582_d()) {
            itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public static EnumDyeColor getColorFromItem(Item itemIn) {
        return BlockShulkerFurnace.getColorFromBlock(Block.func_149634_a((Item)itemIn));
    }

    @SideOnly(value=Side.CLIENT)
    public static EnumDyeColor getColorFromBlock(Block blockIn) {
        return blockIn instanceof BlockShulkerFurnace ? ((BlockShulkerFurnace)blockIn).getColor() : EnumDyeColor.PURPLE;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a(FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b(FACING)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        state = this.func_176221_a(state, worldIn, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b(FACING);
        TileEntityShulkerFurnace.AnimationStatus tileentityshulkerfurnace$animationstatus = ((TileEntityShulkerFurnace)worldIn.func_175625_s(pos)).getAnimationStatus();
        return tileentityshulkerfurnace$animationstatus != TileEntityShulkerFurnace.AnimationStatus.CLOSED && (tileentityshulkerfurnace$animationstatus != TileEntityShulkerFurnace.AnimationStatus.OPENED || enumfacing != face.func_176734_d() && enumfacing != face) ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getColor() {
        return this.color;
    }
}

