/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedIronBars;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityCageTrap;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;

public class BlockCageTrap
extends BlockDisguisable
implements IIntersectable {
    public static final PropertyBool DEACTIVATED = PropertyBool.func_177716_a((String)"deactivated");

    public BlockCageTrap(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        if (BlockUtils.getBlock(world, pos) == SCContent.cageTrap && !((Boolean)BlockUtils.getBlockProperty(world, pos, DEACTIVATED)).booleanValue()) {
            return null;
        }
        return super.func_180646_a(blockState, world, pos);
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityDisguisable) {
            TileEntityDisguisable disguisableTe = (TileEntityDisguisable)te;
            if (entity instanceof EntityPlayer && te instanceof IOwnable && ((IOwnable)te).getOwner().isOwner((EntityPlayer)entity)) {
                this.addCorrectShape(state, world, pos, entityBox, collidingBoxes, entity, isActualState, disguisableTe);
            }
            if (entity instanceof EntityLiving && te instanceof TileEntityCageTrap && !((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                if (((TileEntityCageTrap)te).capturesMobs()) {
                    BlockCageTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
                    return;
                }
                this.addCorrectShape(state, world, pos, entityBox, collidingBoxes, entity, isActualState, disguisableTe);
                return;
            }
            if (entity instanceof EntityItem) {
                this.addCorrectShape(state, world, pos, entityBox, collidingBoxes, entity, isActualState, disguisableTe);
                return;
            }
            if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                this.addCorrectShape(state, world, pos, entityBox, collidingBoxes, entity, isActualState, disguisableTe);
            } else {
                BlockCageTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
            }
        } else {
            BlockCageTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
        }
    }

    private void addCorrectShape(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState, TileEntityDisguisable disguisableTe) {
        ItemStack moduleStack = disguisableTe.getModule(EnumModuleType.DISGUISE);
        if (!moduleStack.func_190926_b() && ((ItemModule)moduleStack.func_77973_b()).getBlockAddons(moduleStack.func_77978_p()).size() > 0) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
        } else {
            BlockCageTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K) {
            TileEntityCageTrap tileEntity = (TileEntityCageTrap)world.func_175625_s(pos);
            boolean isPlayer = entity instanceof EntityPlayer;
            if (isPlayer || entity instanceof EntityMob && tileEntity.capturesMobs()) {
                if (isPlayer && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner((EntityPlayer)entity)) {
                    return;
                }
                if (((Boolean)BlockUtils.getBlockProperty((IBlockAccess)world, pos, DEACTIVATED)).booleanValue()) {
                    return;
                }
                BlockPos topMiddle = pos.func_177981_b(4);
                BlockModifier placer = new BlockModifier(world, new BlockPos.MutableBlockPos(pos), tileEntity.getOwner());
                placer.loop((TriConsumer<World, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                    if (w.func_175623_d((BlockPos)p)) {
                        if (p.equals((Object)topMiddle)) {
                            w.func_175656_a((BlockPos)p, SCContent.horizontalReinforcedIronBars.func_176223_P());
                        } else {
                            w.func_175656_a((BlockPos)p, ((BlockReinforcedIronBars)SCContent.reinforcedIronBars).func_176221_a(SCContent.reinforcedIronBars.func_176223_P(), (IBlockAccess)w, (BlockPos)p));
                        }
                    }
                }));
                placer.loop((TriConsumer<World, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                    TileEntity te = w.func_175625_s((BlockPos)p);
                    if (te instanceof IOwnable) {
                        ((IOwnable)te).getOwner().set((Owner)o);
                    }
                }));
                BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
                world.func_184133_a(null, pos, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 3.0f, 1.0f);
                if (isPlayer) {
                    world.func_73046_m().func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.BLACK + ClientUtils.localize("tile.securitycraft:cageTrap.name", new Object[0]) + TextFormatting.RESET + "] " + ClientUtils.localize("messages.securitycraft:cageTrap.captured", new Object[0]).replace("#player", ((EntityPlayer)entity).func_70005_c_()).replace("#location", Utils.getFormattedCoordinates(pos)), new Object[0]));
                }
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DEACTIVATED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEACTIVATED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCageTrap().intersectsEntities();
    }

    public static class BlockModifier {
        private World world;
        private BlockPos.MutableBlockPos pos;
        private BlockPos origin;
        private Owner owner;

        public BlockModifier(World world, BlockPos.MutableBlockPos origin, Owner owner) {
            this.world = world;
            this.pos = origin.func_181079_c(origin.func_177958_n() - 1, origin.func_177956_o() + 1, origin.func_177952_p() - 1);
            this.origin = origin.func_185334_h();
            this.owner = owner;
        }

        public void loop(TriConsumer<World, BlockPos.MutableBlockPos, Owner> ifTrue) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        if (x != 1 || z != 1 || y == 3) {
                            ifTrue.accept((Object)this.world, (Object)this.pos, (Object)this.owner);
                        }
                        this.pos.func_181079_c(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p() + 1);
                    }
                    this.pos.func_181079_c(this.pos.func_177958_n() + 1, this.pos.func_177956_o(), this.pos.func_177952_p() - 3);
                }
                this.pos.func_181079_c(this.pos.func_177958_n() - 3, this.pos.func_177956_o() + 1, this.pos.func_177952_p());
            }
            this.pos.func_189533_g((Vec3i)this.origin);
        }

        @FunctionalInterface
        public static interface TriFunction<T, U, V, R> {
            public R apply(T var1, U var2, V var3);
        }
    }
}

