/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityWhitelistOnly;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockReinforcedButton
extends BlockButton
implements IReinforcedBlock {
    private final boolean isWooden;

    public BlockReinforcedButton(boolean isWooden) {
        super(isWooden);
        this.isWooden = isWooden;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isAllowedToPress(world, pos, (TileEntityWhitelistOnly)world.func_175625_s(pos), player)) {
            return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, TileEntityWhitelistOnly te, EntityPlayer entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.getPlayersFromModule(world, pos, EnumModuleType.WHITELIST).contains(entity.func_70005_c_().toLowerCase());
    }

    protected void func_185615_a(EntityPlayer player, World world, BlockPos pos) {
        world.func_184133_a(player, pos, this.isWooden ? SoundEvents.field_187885_gS : SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
    }

    protected void func_185617_b(World world, BlockPos pos) {
        world.func_184133_a(null, pos, this.isWooden ? SoundEvents.field_187883_gR : SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityWhitelistOnly();
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(this.isWooden ? Blocks.field_150471_bO : Blocks.field_150430_aB);
    }
}

