/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.containers.ContainerCustomizeBlock;
import net.geforcemods.securitycraft.gui.components.GuiPictureButton;
import net.geforcemods.securitycraft.gui.components.GuiSlider;
import net.geforcemods.securitycraft.network.packets.PacketSToggleOption;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCustomizeBlock
extends GuiContainer {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft:textures/gui/container/customize0.png"), new ResourceLocation("securitycraft:textures/gui/container/customize1.png"), new ResourceLocation("securitycraft:textures/gui/container/customize2.png"), new ResourceLocation("securitycraft:textures/gui/container/customize3.png"), new ResourceLocation("securitycraft:textures/gui/container/customize4.png"), new ResourceLocation("securitycraft:textures/gui/container/customize5.png")};
    private final List<Rectangle> extraAreas = new ArrayList<Rectangle>();
    private IModuleInventory moduleInv;
    private GuiPictureButton[] descriptionButtons = new GuiPictureButton[5];
    private GuiButton[] optionButtons = new GuiButton[5];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private final String blockName;
    private final String title;

    public GuiCustomizeBlock(InventoryPlayer inventory, IModuleInventory te) {
        super((Container)new ContainerCustomizeBlock(inventory, te));
        String tlKey = te.getTileEntity().func_145838_q().func_149739_a();
        this.moduleInv = te;
        this.blockName = tlKey.substring(5);
        this.title = ClientUtils.localize(tlKey + ".name", new Object[0]);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int numberOfColumns = 2;
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            int column = i % 2;
            this.descriptionButtons[i] = new GuiPictureButton(i, this.field_147003_i + 127 + column * 22, this.field_147009_r + 16 + Math.floorDiv(i, 2) * 22, 20, 20, this.field_146296_j, new ItemStack((Item)this.moduleInv.acceptedModules()[i].getItem()));
            this.field_146292_n.add(this.descriptionButtons[i]);
            this.hoverCheckers[i] = new HoverChecker((GuiButton)this.descriptionButtons[i], 20);
        }
        TileEntity te = this.moduleInv.getTileEntity();
        if (te instanceof ICustomizable && ((ICustomizable)te).customOptions() != null) {
            ICustomizable customizableTe = (ICustomizable)te;
            for (int i = 0; i < customizableTe.customOptions().length; ++i) {
                Option<?> option = customizableTe.customOptions()[i];
                if (option instanceof GuiSlider.ISlider && option.isSlider()) {
                    if (option instanceof Option.OptionDouble) {
                        this.optionButtons[i] = new GuiSlider((ClientUtils.localize("option." + this.blockName + "." + option.getName(), new Object[0]) + " ").replace("#", option.toString()), this.blockName, i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, "", (Double)((Option.OptionDouble)option).getMin(), (Double)((Option.OptionDouble)option).getMax(), (Double)((Option.OptionDouble)option).get(), true, true, (GuiSlider.ISlider)((Object)option));
                    } else if (option instanceof Option.OptionInt) {
                        this.optionButtons[i] = new GuiSlider((ClientUtils.localize("option." + this.blockName + "." + option.getName(), new Object[0]) + " ").replace("#", option.toString()), this.blockName, i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, "", (Integer)((Option.OptionInt)option).getMin(), (Integer)((Option.OptionInt)option).getMax(), (Integer)((Option.OptionInt)option).get(), true, true, (GuiSlider.ISlider)((Object)option));
                    }
                    this.optionButtons[i].packedFGColour = 0xE0E0E0;
                } else {
                    this.optionButtons[i] = new GuiButton(i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option));
                    this.optionButtons[i].packedFGColour = option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0;
                }
                this.field_146292_n.add(this.optionButtons[i]);
                this.hoverCheckers[i + this.moduleInv.getMaxNumberOfModules()] = new HoverChecker(this.optionButtons[i], 20);
            }
        }
        for (GuiButton button : this.optionButtons) {
            if (button == null) continue;
            this.extraAreas.add(new Rectangle(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_146285_a(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (i < this.moduleInv.getMaxNumberOfModules()) {
                this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(this.getModuleDescription(i), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
                continue;
            }
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(this.getOptionDescription(i), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(ClientUtils.localize("container.inventory", new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES[this.moduleInv.getMaxNumberOfModules()]);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146284_a(GuiButton button) {
        if (!(button instanceof GuiPictureButton)) {
            Option<?> tempOption = ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[button.field_146127_k];
            tempOption.toggle();
            button.packedFGColour = tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0;
            button.field_146126_j = this.getOptionButtonTitle(tempOption);
            SecurityCraft.network.sendToServer((IMessage)new PacketSToggleOption(this.moduleInv.getTileEntity().func_174877_v().func_177958_n(), this.moduleInv.getTileEntity().func_174877_v().func_177956_o(), this.moduleInv.getTileEntity().func_174877_v().func_177952_p(), button.field_146127_k));
        }
    }

    private String getModuleDescription(int buttonID) {
        String moduleDescription = "module." + this.blockName + "." + this.descriptionButtons[buttonID].getItemStack().func_77658_a().substring(5).replace("securitycraft:", "") + ".description";
        return ClientUtils.localize(this.descriptionButtons[buttonID].getItemStack().func_77658_a() + ".name", new Object[0]) + ":" + TextFormatting.RESET + "\n\n" + ClientUtils.localize(moduleDescription, new Object[0]);
    }

    private String getOptionDescription(int buttonID) {
        String optionDescription = "option." + this.blockName + "." + ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[buttonID - this.moduleInv.getMaxNumberOfModules()].getName() + ".description";
        return ClientUtils.localize(optionDescription, new Object[0]);
    }

    private String getOptionButtonTitle(Option<?> option) {
        return (ClientUtils.localize("option." + this.blockName + "." + option.getName(), new Object[0]) + " ").replace("#", option.toString());
    }

    public List<Rectangle> getGuiExtraAreas() {
        return this.extraAreas;
    }
}

