/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import net.geforcemods.securitycraft.containers.ContainerInventoryScanner;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiInventoryScanner
extends GuiContainer {
    private static final ResourceLocation regularInventory = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation exhancedInventory = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    private TileEntityInventoryScanner tileEntity;
    private EntityPlayer playerObj;
    private boolean owns = false;
    private boolean hasStorageModule = false;
    private String storageString;
    private String redstoneString;

    public GuiInventoryScanner(InventoryPlayer inventory, TileEntityInventoryScanner te, EntityPlayer player) {
        super((Container)new ContainerInventoryScanner(inventory, te));
        this.tileEntity = te;
        this.playerObj = player;
        this.owns = this.tileEntity.getOwner().isOwner(this.playerObj);
        this.hasStorageModule = this.tileEntity.hasModule(EnumModuleType.STORAGE);
        this.storageString = ClientUtils.localize("gui.securitycraft:invScan.check_inv", ClientUtils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0]));
        this.redstoneString = ClientUtils.localize("gui.securitycraft:invScan.emit_redstone", ClientUtils.localize("gui.securitycraft:invScan." + (this.tileEntity.hasModule(EnumModuleType.REDSTONE) ? "yes" : "no"), new Object[0]));
        this.field_146999_f = this.hasStorageModule ? 236 : 176;
        this.field_147000_g = 196;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        this.field_146289_q.func_78276_b(this.redstoneString, this.field_147003_i + 5, this.field_147009_r + 40, 0x404040);
        this.field_146289_q.func_78276_b(this.storageString, this.field_147003_i + 5, this.field_147009_r + 50, 0x404040);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_146285_a(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b("Prohibited Items", 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.tileEntity.getOwner().isOwner(this.playerObj) ? TextFormatting.UNDERLINE + ClientUtils.localize("gui.securitycraft:invScan.mode.admin", new Object[0]) : TextFormatting.UNDERLINE + ClientUtils.localize("gui.securitycraft:invScan.mode.view", new Object[0]), 112, 6, 0x404040);
        if (this.hasStorageModule && this.owns) {
            this.field_146289_q.func_78276_b("Storage", 183, 6, 0x404040);
        }
        this.field_146289_q.func_78276_b(ClientUtils.localize("container.inventory", new Object[0]), 8, this.field_147000_g - 93, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hasStorageModule && this.owns) {
            this.field_146297_k.func_110434_K().func_110577_a(exhancedInventory);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(regularInventory);
        }
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g + 30);
    }
}

