/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.TileEntityOwnable;
import net.geforcemods.securitycraft.blocks.BlockCageTrap;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntityLaserBlock;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.IBlockWithNoDrops;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;

public class ItemUniversalBlockRemover
extends Item {
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.isOwnableBlock(block, tileEntity)) {
            if (!((IOwnable)tileEntity).getOwner().isOwner(player)) {
                if (world.field_72995_K && !(block instanceof IBlockMine) && (!(tileEntity instanceof TileEntityDisguisable) || ((ItemBlock)((BlockDisguisable)((TileEntityDisguisable)tileEntity).func_145838_q()).getDisguisedStack((IBlockAccess)world, pos).func_77973_b()).func_179223_d() instanceof BlockDisguisable)) {
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("item.securitycraft:universalBlockRemover.name", new Object[0]), ClientUtils.localize("messages.securitycraft:notOwned", new Object[0]).replace("#", ((IOwnable)tileEntity).getOwner().getName()), TextFormatting.RED);
                }
                return EnumActionResult.FAIL;
            }
            if (!world.field_72995_K) {
                if (tileEntity instanceof IModuleInventory) {
                    boolean isChest = tileEntity instanceof TileEntityKeypadChest;
                    for (ItemStack module : ((IModuleInventory)tileEntity).getInventory()) {
                        if (isChest) {
                            ((TileEntityKeypadChest)tileEntity).addOrRemoveModuleFromAttached(module, true);
                        }
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)module);
                    }
                }
                if (block == SCContent.laserBlock) {
                    TileEntityLaserBlock te = (TileEntityLaserBlock)world.func_175625_s(pos);
                    for (ItemStack module : te.getInventory()) {
                        if (module.func_190926_b()) continue;
                        te.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{module, ((ItemModule)module.func_77973_b()).getModuleType()}, te);
                    }
                    world.func_175655_b(pos, true);
                    BlockLaserBlock.destroyAdjacentLasers(world, pos);
                    player.field_71071_by.func_70448_g().func_77972_a(1, (EntityLivingBase)player);
                } else if (block == SCContent.cageTrap && ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)BlockCageTrap.DEACTIVATED)).booleanValue()) {
                    BlockPos originalPos = pos;
                    BlockPos middlePos = originalPos.func_177981_b(4);
                    new BlockCageTrap.BlockModifier(world, new BlockPos.MutableBlockPos(originalPos), ((IOwnable)tileEntity).getOwner()).loop((TriConsumer<World, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                        Block b;
                        TileEntity te = w.func_175625_s((BlockPos)p);
                        if (te instanceof IOwnable && ((IOwnable)te).getOwner().equals(o) && ((b = w.func_180495_p((BlockPos)p).func_177230_c()) == SCContent.reinforcedIronBars || p.equals((Object)middlePos) && b == SCContent.horizontalReinforcedIronBars)) {
                            w.func_175655_b((BlockPos)p, false);
                        }
                    }));
                    world.func_175655_b(originalPos, false);
                } else {
                    if (block == SCContent.inventoryScanner) {
                        TileEntityInventoryScanner te = BlockInventoryScanner.getConnectedInventoryScanner(world, pos);
                        if (te != null) {
                            te.getInventory().clear();
                        }
                    } else if (block instanceof IBlockWithNoDrops) {
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)((IBlockWithNoDrops)block).getUniversalBlockRemoverDrop());
                    }
                    world.func_175655_b(pos, true);
                    world.func_175713_t(pos);
                    player.field_71071_by.func_70448_g().func_77972_a(1, (EntityLivingBase)player);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean isOwnableBlock(Block block, TileEntity tileEntity) {
        return tileEntity instanceof TileEntityOwnable || tileEntity instanceof IOwnable || block instanceof BlockOwnable;
    }
}

