/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.tileentity.TileEntityProjector;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSSyncProjector
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int width;
    private int range;
    private int offset;

    public PacketSSyncProjector() {
    }

    public PacketSSyncProjector(int x, int y, int z, int width, int range, int offset) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.range = range;
        this.offset = offset;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.width = buf.readInt();
        this.range = buf.readInt();
        this.offset = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.width);
        buf.writeInt(this.range);
        buf.writeInt(this.offset);
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSSyncProjector, IMessage> {
        public IMessage onMessage(PacketSSyncProjector message, MessageContext ctx) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)ctx.getServerHandler().field_147369_b), () -> {
                BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
                World world = ctx.getServerHandler().field_147369_b.field_70170_p;
                TileEntity te = world.func_175625_s(pos);
                if (world.func_175667_e(pos) && te instanceof TileEntityProjector) {
                    TileEntityProjector projector = (TileEntityProjector)te;
                    IBlockState state = world.func_180495_p(pos);
                    projector.setProjectionWidth(message.width);
                    projector.setProjectionRange(message.range);
                    projector.setProjectionOffset(message.offset);
                    world.func_184138_a(pos, state, state, 2);
                }
            });
            return null;
        }
    }
}

