/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.TileEntityOwnable;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetCameraPowered
implements IMessage {
    private BlockPos pos;
    private boolean powered;

    public PacketSetCameraPowered() {
    }

    public PacketSetCameraPowered(BlockPos pos, boolean powered) {
        this.pos = pos;
        this.powered = powered;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.powered);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.powered = buf.readBoolean();
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSetCameraPowered, IMessage> {
        public IMessage onMessage(PacketSetCameraPowered message, MessageContext context) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), () -> {
                BlockPos pos = message.pos;
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                TileEntity te = world.func_175625_s(pos);
                NBTTagCompound modules = ((IModuleInventory)te).writeModuleInventory(new NBTTagCompound());
                Owner owner = ((TileEntityOwnable)te).getOwner();
                world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BlockSecurityCamera.POWERED, (Comparable)Boolean.valueOf(message.powered)));
                ((IModuleInventory)te).readModuleInventory(modules);
                ((TileEntityOwnable)te).getOwner().set(owner.getUUID(), owner.getName());
                world.func_175685_c(pos.func_177967_a((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), world.func_180495_p(pos).func_177230_c(), false);
            });
            return null;
        }
    }
}

