/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;

public class TileEntityKeycardReader
extends TileEntityDisguisable
implements IPasswordProtected {
    private int passLV = 0;
    private boolean requiresExactKeycard = false;
    private Option.OptionBoolean sendMessage = new Option.OptionBoolean("sendMessage", true);
    private Option.OptionInt signalLength = new Option.OptionInt(this, "signalLength", 60, 5, 400, 5, true);

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("passLV", this.passLV);
        tag.func_74757_a("requiresExactKeycard", this.requiresExactKeycard);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("passLV")) {
            this.passLV = tag.func_74762_e("passLV");
        }
        if (tag.func_74764_b("requiresExactKeycard")) {
            this.requiresExactKeycard = tag.func_74767_n("requiresExactKeycard");
        }
    }

    public void setRequiresExactKeycard(boolean par1) {
        this.requiresExactKeycard = par1;
    }

    public boolean doesRequireExactKeycard() {
        return this.requiresExactKeycard;
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock((IBlockAccess)this.func_145831_w(), this.func_174877_v()) instanceof BlockKeycardReader) {
            BlockKeycardReader.activate(this.field_145850_b, this.func_174877_v(), (Integer)this.signalLength.get());
        }
    }

    @Override
    public void openPasswordGUI(EntityPlayer player) {
        if (this.getPassword() == null) {
            if (this.getOwner().isOwner(player)) {
                player.openGui((Object)SecurityCraft.instance, 1, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            } else {
                PlayerUtils.sendMessageToPlayer(player, "SecurityCraft", ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
            }
        }
    }

    @Override
    public boolean onCodebreakerUsed(IBlockState blockState, EntityPlayer player, boolean isCodebreakerDisabled) {
        return false;
    }

    @Override
    public String getPassword() {
        return this.passLV == 0 ? null : String.valueOf(this.passLV);
    }

    @Override
    public void setPassword(String password) {
        this.passLV = Integer.parseInt(password);
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.WHITELIST, EnumModuleType.BLACKLIST, EnumModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }
}

