/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.TileEntityOwnable;
import net.geforcemods.securitycraft.blocks.BlockKeypadFurnace;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityKeypadFurnace
extends TileEntityOwnable
implements ISidedInventory,
IPasswordProtected,
ITickable,
IModuleInventory,
ICustomizable {
    private static final EmptyHandler EMPTY_INVENTORY = new EmptyHandler();
    private IItemHandler insertOnlyHandler;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    public NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int cookTime;
    public int totalCookTime;
    private String furnaceCustomName;
    private String passcode;
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Option.OptionBoolean sendMessage = new Option.OptionBoolean("sendMessage", true);

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public ItemStack func_70301_a(int index) {
        return index >= 100 ? this.getModuleInSlot(index) : (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.furnaceItemStacks.get(index)).func_190926_b()) {
            if (((ItemStack)this.furnaceItemStacks.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.furnaceItemStacks.get(index);
                this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
                return stack;
            }
            ItemStack stack = ((ItemStack)this.furnaceItemStacks.get(index)).func_77979_a(count);
            if (((ItemStack)this.furnaceItemStacks.get(index)).func_190916_E() == 0) {
                this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (!((ItemStack)this.furnaceItemStacks.get(index)).func_190926_b()) {
            ItemStack stack = (ItemStack)this.furnaceItemStacks.get(index);
            this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean areStacksEqual = !stack.func_190926_b() && stack.func_77969_a((ItemStack)this.furnaceItemStacks.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.furnaceItemStacks.get(index)));
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !areStacksEqual) {
            this.totalCookTime = this.getTotalCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : "container.furnace";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && this.furnaceCustomName.length() > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)slot, (Object)new ItemStack(stackTag));
        }
        this.furnaceBurnTime = tag.func_74765_d("BurnTime");
        this.cookTime = tag.func_74765_d("CookTime");
        this.totalCookTime = tag.func_74765_d("CookTimeTotal");
        this.currentItemBurnTime = TileEntityKeypadFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
        this.passcode = tag.func_74779_i("passcode");
        if (tag.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = tag.func_74779_i("CustomName");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        tag.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tag.func_74777_a("CookTime", (short)this.cookTime);
        tag.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return tag;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scaleFactor) {
        return this.cookTime * scaleFactor / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scaleFactor) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * scaleFactor / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        boolean isBurning = this.isBurning();
        boolean shouldMarkDirty = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isBurning() && (((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() || ((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b())) {
                if (!this.isBurning() && this.cookTime > 0) {
                    this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
                }
            } else {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityKeypadFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
                    if (this.isBurning()) {
                        shouldMarkDirty = true;
                        if (!((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                            ((ItemStack)this.furnaceItemStacks.get(1)).func_190918_g(1);
                            if (((ItemStack)this.furnaceItemStacks.get(1)).func_190916_E() == 0) {
                                this.furnaceItemStacks.set(1, (Object)((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b().getContainerItem((ItemStack)this.furnaceItemStacks.get(1)));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getTotalCookTime();
                        this.smeltItem();
                        shouldMarkDirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (isBurning != this.isBurning()) {
                shouldMarkDirty = true;
            }
        }
        if (shouldMarkDirty) {
            this.func_70296_d();
        }
    }

    public int getTotalCookTime() {
        return 200;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (smeltResult.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.furnaceItemStacks.get(2)).func_77969_a(smeltResult)) {
            return false;
        }
        int result = ((ItemStack)this.furnaceItemStacks.get(2)).func_190916_E() + smeltResult.func_190916_E();
        return result <= this.func_70297_j_() && result <= ((ItemStack)this.furnaceItemStacks.get(2)).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
            if (((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)smeltResult.func_77946_l());
            } else if (((ItemStack)this.furnaceItemStacks.get(2)).func_77973_b() == smeltResult.func_77973_b()) {
                ((ItemStack)this.furnaceItemStacks.get(2)).func_190917_f(smeltResult.func_190916_E());
            }
            if (((ItemStack)this.furnaceItemStacks.get(0)).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && ((ItemStack)this.furnaceItemStacks.get(0)).func_77960_j() == 1 && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            ((ItemStack)this.furnaceItemStacks.get(0)).func_190918_g(1);
            if (((ItemStack)this.furnaceItemStacks.get(0)).func_190916_E() <= 0) {
                this.furnaceItemStacks.set(0, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o(block.func_176223_P()) == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityKeypadFurnace.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2 ? false : (index != 1 ? true : TileEntityKeypadFurnace.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            this.furnaceItemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            BlockPos offsetPos = this.field_174879_c.func_177972_a(facing);
            IBlockState state = this.field_145850_b.func_180495_p(offsetPos);
            for (IExtractionBlock extractionBlock : SecurityCraft.getRegisteredExtractionBlocks()) {
                if (state.func_177230_c() != extractionBlock.getBlock()) continue;
                if (!extractionBlock.canExtract(this, this.field_145850_b, offsetPos, state)) {
                    return (T)EMPTY_INVENTORY;
                }
                return (T)super.getCapability(capability, facing);
            }
            return (T)this.getInsertOnlyHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    private IItemHandler getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = new InsertOnlyInvWrapper(this);
        }
        return this.insertOnlyHandler;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock((IBlockAccess)this.func_145831_w(), this.func_174877_v()) instanceof BlockKeypadFurnace) {
            BlockKeypadFurnace.activate(this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public void openPasswordGUI(EntityPlayer player) {
        if (this.getPassword() != null) {
            player.openGui((Object)SecurityCraft.instance, 10, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else if (this.getOwner().isOwner(player)) {
            player.openGui((Object)SecurityCraft.instance, 9, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else {
            PlayerUtils.sendMessageToPlayer(player, "SecurityCraft", ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(IBlockState blockState, EntityPlayer player, boolean isCodebreakerDisabled) {
        if (!isCodebreakerDisabled) {
            this.activate(player);
            return true;
        }
        PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:keypadFurnace.name", new Object[0]), ClientUtils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.WHITELIST, EnumModuleType.BLACKLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }
}

