/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityProjector
extends TileEntityDisguisable
implements IInventory {
    public static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 10;
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 30;
    public static final int MIN_OFFSET = -10;
    public static final int MAX_OFFSET = 10;
    public static final int RENDER_DISTANCE = 100;
    private int projectionWidth = 1;
    private int projectionRange = 5;
    private int projectionOffset = 0;
    public boolean activatedByRedstone = false;
    public boolean active = false;
    private ItemStack projectedBlock = ItemStack.field_190927_a;

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(100.0);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("width", this.projectionWidth);
        tag.func_74768_a("range", this.projectionRange);
        tag.func_74768_a("offset", this.projectionOffset);
        this.activatedByRedstone = this.hasModule(EnumModuleType.REDSTONE);
        tag.func_74757_a("active", this.active);
        if (!this.func_191420_l()) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.projectedBlock.func_77955_b(itemTag);
            tag.func_74782_a("storedItem", (NBTBase)itemTag);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("width")) {
            this.projectionWidth = tag.func_74762_e("width");
        }
        if (tag.func_74764_b("range")) {
            this.projectionRange = tag.func_74762_e("range");
        }
        if (tag.func_74764_b("offset")) {
            this.projectionOffset = tag.func_74762_e("offset");
        }
        this.activatedByRedstone = this.hasModule(EnumModuleType.REDSTONE);
        if (tag.func_74764_b("active")) {
            this.active = tag.func_74767_n("active");
        }
        if (tag.func_74764_b("storedItem")) {
            this.projectedBlock = new ItemStack(tag.func_74775_l("storedItem"));
        }
    }

    public int getProjectionWidth() {
        return this.projectionWidth;
    }

    public void setProjectionWidth(int width) {
        this.projectionWidth = width;
    }

    public int getProjectionRange() {
        return this.projectionRange;
    }

    public void setProjectionRange(int range) {
        this.projectionRange = range;
    }

    public int getProjectionOffset() {
        return this.projectionOffset;
    }

    public void setProjectionOffset(int offset) {
        this.projectionOffset = offset;
    }

    public boolean isActivatedByRedstone() {
        return this.activatedByRedstone;
    }

    public void setActivatedByRedstone(boolean redstone) {
        this.activatedByRedstone = redstone;
    }

    public boolean isActive() {
        return this.activatedByRedstone ? this.active : true;
    }

    public void setActive(boolean isOn) {
        this.active = isOn;
    }

    public Block getProjectedBlock() {
        return Block.func_149634_a((Item)this.projectedBlock.func_77973_b());
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module) {
        super.onModuleInserted(stack, module);
        if (module == EnumModuleType.REDSTONE) {
            this.setActivatedByRedstone(true);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == EnumModuleType.REDSTONE) {
            this.setActivatedByRedstone(false);
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.DISGUISE, EnumModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public void func_174888_l() {
        this.projectedBlock = ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.projectedBlock;
        if (count >= 1) {
            this.projectedBlock = ItemStack.field_190927_a;
        }
        return stack;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (slot == 36 ? this.projectedBlock : ItemStack.field_190927_a);
    }

    public boolean func_191420_l() {
        return this.projectedBlock.func_190926_b();
    }

    public boolean func_70300_a(EntityPlayer arg0) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.projectedBlock;
        this.projectedBlock = ItemStack.field_190927_a;
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack = new ItemStack(stack.func_77973_b(), this.func_70297_j_());
        }
        this.projectedBlock = stack;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public String func_70005_c_() {
        return "Projector";
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlock;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

