/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.io.File;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.packets.PacketSSyncTENBTTag;
import net.geforcemods.securitycraft.network.packets.PacketSUpdateNBTTag;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientUtils {
    @SideOnly(value=Side.CLIENT)
    public static void closePlayerScreen() {
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    @SideOnly(value=Side.CLIENT)
    public static void takeScreenshot() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(ScreenShotHelper.func_148260_a((File)Minecraft.func_71410_x().field_71412_D, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (Framebuffer)Minecraft.func_71410_x().func_147110_a()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String getFormattedMinecraftTime() {
        Long time = Minecraft.func_71410_x().field_71441_e.field_73011_w.getWorldTime();
        int hours24 = (int)((float)time.longValue() / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        return String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncTileEntity(TileEntity tileEntity) {
        NBTTagCompound tag = new NBTTagCompound();
        tileEntity.func_189515_b(tag);
        SecurityCraft.network.sendToServer((IMessage)new PacketSSyncTENBTTag(tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p(), tag));
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncItemNBT(ItemStack item) {
        SecurityCraft.network.sendToServer((IMessage)new PacketSUpdateNBTTag(item));
    }

    public static String localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof TextComponentTranslation) {
                params[i] = ClientUtils.localize(((TextComponentTranslation)params[i]).func_150268_i(), ((TextComponentTranslation)params[i]).func_150271_j());
                continue;
            }
            if (!(params[i] instanceof BlockPos)) continue;
            params[i] = Utils.getFormattedCoordinates((BlockPos)params[i]);
        }
        return String.format(I18n.func_74838_a((String)key), params);
    }
}

